/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32659")
public class ReferenceDescriptionDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReferenceDescriptionDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReferenceDescriptionDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReferenceDescriptionDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReferenceDescriptionDataType;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_sourceNode;
    private NodeId f_referenceType;
    private Boolean f_isForward;
    private ExpandedNodeId f_targetNode;

    public ReferenceDescriptionDataType() {
    }

    public ReferenceDescriptionDataType(NodeId nodeId, NodeId nodeId2, Boolean bl, ExpandedNodeId expandedNodeId) {
        this.f_sourceNode = nodeId;
        this.f_referenceType = nodeId2;
        this.f_isForward = bl;
        this.f_targetNode = expandedNodeId;
    }

    public NodeId getSourceNode() {
        return this.f_sourceNode;
    }

    public void setSourceNode(NodeId nodeId) {
        this.f_sourceNode = nodeId;
    }

    public NodeId getReferenceType() {
        return this.f_referenceType;
    }

    public void setReferenceType(NodeId nodeId) {
        this.f_referenceType = nodeId;
    }

    public Boolean getIsForward() {
        return this.f_isForward;
    }

    public void setIsForward(Boolean bl) {
        this.f_isForward = bl;
    }

    public ExpandedNodeId getTargetNode() {
        return this.f_targetNode;
    }

    public void setTargetNode(ExpandedNodeId expandedNodeId) {
        this.f_targetNode = expandedNodeId;
    }

    @Override
    public ReferenceDescriptionDataType clone() {
        ReferenceDescriptionDataType referenceDescriptionDataType = (ReferenceDescriptionDataType)super.clone();
        referenceDescriptionDataType.f_sourceNode = StructureUtils.clone(this.f_sourceNode);
        referenceDescriptionDataType.f_referenceType = StructureUtils.clone(this.f_referenceType);
        referenceDescriptionDataType.f_isForward = StructureUtils.clone(this.f_isForward);
        referenceDescriptionDataType.f_targetNode = StructureUtils.clone(this.f_targetNode);
        return referenceDescriptionDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceDescriptionDataType referenceDescriptionDataType = (ReferenceDescriptionDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSourceNode(), referenceDescriptionDataType.getSourceNode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReferenceType(), referenceDescriptionDataType.getReferenceType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsForward(), referenceDescriptionDataType.getIsForward())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getTargetNode(), referenceDescriptionDataType.getTargetNode());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getSourceNode(), this.getReferenceType(), this.getIsForward(), this.getTargetNode());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_sourceNode = null;
        this.f_referenceType = null;
        this.f_isForward = null;
        this.f_targetNode = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Comparable<NodeId>> linkedHashMap = new LinkedHashMap<Fields, Comparable<NodeId>>();
        linkedHashMap.put(Fields.SourceNode, this.getSourceNode());
        linkedHashMap.put(Fields.ReferenceType, this.getReferenceType());
        linkedHashMap.put(Fields.IsForward, this.getIsForward());
        linkedHashMap.put(Fields.TargetNode, this.getTargetNode());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SourceNode.equals(fieldSpecification)) {
            return this.getSourceNode();
        }
        if (Fields.ReferenceType.equals(fieldSpecification)) {
            return this.getReferenceType();
        }
        if (Fields.IsForward.equals(fieldSpecification)) {
            return this.getIsForward();
        }
        if (Fields.TargetNode.equals(fieldSpecification)) {
            return this.getTargetNode();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SourceNode.equals(fieldSpecification)) {
            this.setSourceNode((NodeId)object);
            return;
        }
        if (Fields.ReferenceType.equals(fieldSpecification)) {
            this.setReferenceType((NodeId)object);
            return;
        }
        if (Fields.IsForward.equals(fieldSpecification)) {
            this.setIsForward((Boolean)object);
            return;
        }
        if (Fields.TargetNode.equals(fieldSpecification)) {
            this.setTargetNode((ExpandedNodeId)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReferenceDescriptionDataType.builder();
        builder.setSourceNode(StructureUtils.clone(this.getSourceNode()));
        builder.setReferenceType(StructureUtils.clone(this.getReferenceType()));
        builder.setIsForward(StructureUtils.clone(this.getIsForward()));
        builder.setTargetNode(StructureUtils.clone(this.getTargetNode()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SourceNode);
        builder.addField(Fields.ReferenceType);
        builder.addField(Fields.IsForward);
        builder.addField(Fields.TargetNode);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ReferenceDescriptionDataType");
        builder.setJavaClass(ReferenceDescriptionDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId f_sourceNode;
        private NodeId f_referenceType;
        private Boolean f_isForward;
        private ExpandedNodeId f_targetNode;

        protected Builder() {
        }

        public NodeId getSourceNode() {
            return this.f_sourceNode;
        }

        public Builder setSourceNode(NodeId nodeId) {
            this.f_sourceNode = nodeId;
            return this;
        }

        public NodeId getReferenceType() {
            return this.f_referenceType;
        }

        public Builder setReferenceType(NodeId nodeId) {
            this.f_referenceType = nodeId;
            return this;
        }

        public Boolean getIsForward() {
            return this.f_isForward;
        }

        public Builder setIsForward(Boolean bl) {
            this.f_isForward = bl;
            return this;
        }

        public ExpandedNodeId getTargetNode() {
            return this.f_targetNode;
        }

        public Builder setTargetNode(ExpandedNodeId expandedNodeId) {
            this.f_targetNode = expandedNodeId;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getSourceNode(), builder.getSourceNode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getReferenceType(), builder.getReferenceType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getIsForward(), builder.getIsForward())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getTargetNode(), builder.getTargetNode());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getSourceNode(), this.getReferenceType(), this.getIsForward(), this.getTargetNode());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.SourceNode.equals(fieldSpecification)) {
                return this.getSourceNode();
            }
            if (Fields.ReferenceType.equals(fieldSpecification)) {
                return this.getReferenceType();
            }
            if (Fields.IsForward.equals(fieldSpecification)) {
                return this.getIsForward();
            }
            if (Fields.TargetNode.equals(fieldSpecification)) {
                return this.getTargetNode();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SourceNode.equals(fieldSpecification)) {
                this.setSourceNode((NodeId)object);
                return this;
            }
            if (Fields.ReferenceType.equals(fieldSpecification)) {
                this.setReferenceType((NodeId)object);
                return this;
            }
            if (Fields.IsForward.equals(fieldSpecification)) {
                this.setIsForward((Boolean)object);
                return this;
            }
            if (Fields.TargetNode.equals(fieldSpecification)) {
                this.setTargetNode((ExpandedNodeId)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_sourceNode = null;
            this.f_referenceType = null;
            this.f_isForward = null;
            this.f_targetNode = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ReferenceDescriptionDataType build() {
            return new ReferenceDescriptionDataType(this.f_sourceNode, this.f_referenceType, this.f_isForward, this.f_targetNode);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SourceNode("SourceNode", NodeId.class, false, UaIds.NodeId, -1, null, false),
        ReferenceType("ReferenceType", NodeId.class, false, UaIds.NodeId, -1, null, false),
        IsForward("IsForward", Boolean.class, false, UaIds.Boolean, -1, null, false),
        TargetNode("TargetNode", ExpandedNodeId.class, false, UaIds.ExpandedNodeId, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

