/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.DataSetReaderDataType;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.PubSubGroupDataType;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15520")
public class ReaderGroupDataType
extends PubSubGroupDataType {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReaderGroupDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReaderGroupDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReaderGroupDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReaderGroupDataType;
    public static final StructureSpecification SPECIFICATION;
    private ExtensionObject f_transportSettings;
    private ExtensionObject f_messageSettings;
    private DataSetReaderDataType[] f_dataSetReaders;

    public ReaderGroupDataType() {
    }

    public ReaderGroupDataType(ExtensionObject extensionObject, ExtensionObject extensionObject2, DataSetReaderDataType[] dataSetReaderDataTypeArray) {
        this.f_transportSettings = extensionObject;
        this.f_messageSettings = extensionObject2;
        this.f_dataSetReaders = dataSetReaderDataTypeArray;
    }

    public ReaderGroupDataType(String string, Boolean bl, MessageSecurityMode messageSecurityMode, String string2, EndpointDescription[] endpointDescriptionArray, UnsignedInteger unsignedInteger, KeyValuePair[] keyValuePairArray, ExtensionObject extensionObject, ExtensionObject extensionObject2, DataSetReaderDataType[] dataSetReaderDataTypeArray) {
        super(string, bl, messageSecurityMode, string2, endpointDescriptionArray, unsignedInteger, keyValuePairArray);
        this.f_transportSettings = extensionObject;
        this.f_messageSettings = extensionObject2;
        this.f_dataSetReaders = dataSetReaderDataTypeArray;
    }

    public ExtensionObject getTransportSettings() {
        return this.f_transportSettings;
    }

    public void setTransportSettings(ExtensionObject extensionObject) {
        this.f_transportSettings = extensionObject;
    }

    public ExtensionObject getMessageSettings() {
        return this.f_messageSettings;
    }

    public void setMessageSettings(ExtensionObject extensionObject) {
        this.f_messageSettings = extensionObject;
    }

    public DataSetReaderDataType[] getDataSetReaders() {
        return this.f_dataSetReaders;
    }

    public void setDataSetReaders(DataSetReaderDataType[] dataSetReaderDataTypeArray) {
        this.f_dataSetReaders = dataSetReaderDataTypeArray;
    }

    @Override
    public ReaderGroupDataType clone() {
        ReaderGroupDataType readerGroupDataType = (ReaderGroupDataType)super.clone();
        readerGroupDataType.f_transportSettings = StructureUtils.clone(this.f_transportSettings);
        readerGroupDataType.f_messageSettings = StructureUtils.clone(this.f_messageSettings);
        readerGroupDataType.f_dataSetReaders = StructureUtils.clone(this.f_dataSetReaders);
        return readerGroupDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReaderGroupDataType readerGroupDataType = (ReaderGroupDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), readerGroupDataType.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnabled(), readerGroupDataType.getEnabled())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), readerGroupDataType.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityGroupId(), readerGroupDataType.getSecurityGroupId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityKeyServices(), readerGroupDataType.getSecurityKeyServices())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxNetworkMessageSize(), readerGroupDataType.getMaxNetworkMessageSize())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getGroupProperties(), readerGroupDataType.getGroupProperties())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTransportSettings(), readerGroupDataType.getTransportSettings())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMessageSettings(), readerGroupDataType.getMessageSettings())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDataSetReaders(), readerGroupDataType.getDataSetReaders());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getName(), this.getEnabled(), this.getSecurityMode(), this.getSecurityGroupId(), this.getSecurityKeyServices(), this.getMaxNetworkMessageSize(), this.getGroupProperties(), this.getTransportSettings(), this.getMessageSettings(), this.getDataSetReaders());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_transportSettings = null;
        this.f_messageSettings = null;
        this.f_dataSetReaders = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Name, this.getName());
        linkedHashMap.put(Fields.Enabled, this.getEnabled());
        linkedHashMap.put(Fields.SecurityMode, this.getSecurityMode());
        linkedHashMap.put(Fields.SecurityGroupId, this.getSecurityGroupId());
        linkedHashMap.put(Fields.SecurityKeyServices, this.getSecurityKeyServices());
        linkedHashMap.put(Fields.MaxNetworkMessageSize, this.getMaxNetworkMessageSize());
        linkedHashMap.put(Fields.GroupProperties, this.getGroupProperties());
        linkedHashMap.put(Fields.TransportSettings, this.getTransportSettings());
        linkedHashMap.put(Fields.MessageSettings, this.getMessageSettings());
        linkedHashMap.put(Fields.DataSetReaders, this.getDataSetReaders());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.Enabled.equals(fieldSpecification)) {
            return this.getEnabled();
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.SecurityGroupId.equals(fieldSpecification)) {
            return this.getSecurityGroupId();
        }
        if (Fields.SecurityKeyServices.equals(fieldSpecification)) {
            return this.getSecurityKeyServices();
        }
        if (Fields.MaxNetworkMessageSize.equals(fieldSpecification)) {
            return this.getMaxNetworkMessageSize();
        }
        if (Fields.GroupProperties.equals(fieldSpecification)) {
            return this.getGroupProperties();
        }
        if (Fields.TransportSettings.equals(fieldSpecification)) {
            return this.getTransportSettings();
        }
        if (Fields.MessageSettings.equals(fieldSpecification)) {
            return this.getMessageSettings();
        }
        if (Fields.DataSetReaders.equals(fieldSpecification)) {
            return this.getDataSetReaders();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.Enabled.equals(fieldSpecification)) {
            this.setEnabled((Boolean)object);
            return;
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.SecurityGroupId.equals(fieldSpecification)) {
            this.setSecurityGroupId((String)object);
            return;
        }
        if (Fields.SecurityKeyServices.equals(fieldSpecification)) {
            this.setSecurityKeyServices((EndpointDescription[])object);
            return;
        }
        if (Fields.MaxNetworkMessageSize.equals(fieldSpecification)) {
            this.setMaxNetworkMessageSize((UnsignedInteger)object);
            return;
        }
        if (Fields.GroupProperties.equals(fieldSpecification)) {
            this.setGroupProperties((KeyValuePair[])object);
            return;
        }
        if (Fields.TransportSettings.equals(fieldSpecification)) {
            this.setTransportSettings((ExtensionObject)object);
            return;
        }
        if (Fields.MessageSettings.equals(fieldSpecification)) {
            this.setMessageSettings((ExtensionObject)object);
            return;
        }
        if (Fields.DataSetReaders.equals(fieldSpecification)) {
            this.setDataSetReaders((DataSetReaderDataType[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReaderGroupDataType.builder();
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setEnabled(StructureUtils.clone(this.getEnabled()));
        builder.setSecurityMode(StructureUtils.clone(this.getSecurityMode()));
        builder.setSecurityGroupId(StructureUtils.clone(this.getSecurityGroupId()));
        builder.setSecurityKeyServices(StructureUtils.clone(this.getSecurityKeyServices()));
        builder.setMaxNetworkMessageSize(StructureUtils.clone(this.getMaxNetworkMessageSize()));
        builder.setGroupProperties(StructureUtils.clone(this.getGroupProperties()));
        builder.setTransportSettings(StructureUtils.clone(this.getTransportSettings()));
        builder.setMessageSettings(StructureUtils.clone(this.getMessageSettings()));
        builder.setDataSetReaders(StructureUtils.clone(this.getDataSetReaders()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Name);
        builder.addField(Fields.Enabled);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.SecurityGroupId);
        builder.addField(Fields.SecurityKeyServices);
        builder.addField(Fields.MaxNetworkMessageSize);
        builder.addField(Fields.GroupProperties);
        builder.addField(Fields.TransportSettings);
        builder.addField(Fields.MessageSettings);
        builder.addField(Fields.DataSetReaders);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.PubSubGroupDataType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ReaderGroupDataType");
        builder.setJavaClass(ReaderGroupDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.SUBTYPES);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends PubSubGroupDataType.Builder {
        private String f_name;
        private Boolean f_enabled;
        private MessageSecurityMode f_securityMode;
        private String f_securityGroupId;
        private EndpointDescription[] f_securityKeyServices;
        private UnsignedInteger f_maxNetworkMessageSize;
        private KeyValuePair[] f_groupProperties;
        private ExtensionObject f_transportSettings;
        private ExtensionObject f_messageSettings;
        private DataSetReaderDataType[] f_dataSetReaders;

        protected Builder() {
        }

        @Override
        public String getName() {
            return this.f_name;
        }

        @Override
        public Builder setName(String string) {
            this.f_name = string;
            return this;
        }

        @Override
        public Boolean getEnabled() {
            return this.f_enabled;
        }

        @Override
        public Builder setEnabled(Boolean bl) {
            this.f_enabled = bl;
            return this;
        }

        @Override
        public MessageSecurityMode getSecurityMode() {
            return this.f_securityMode;
        }

        @Override
        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.f_securityMode = messageSecurityMode;
            return this;
        }

        @Override
        public String getSecurityGroupId() {
            return this.f_securityGroupId;
        }

        @Override
        public Builder setSecurityGroupId(String string) {
            this.f_securityGroupId = string;
            return this;
        }

        @Override
        public EndpointDescription[] getSecurityKeyServices() {
            return this.f_securityKeyServices;
        }

        @Override
        public Builder setSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) {
            this.f_securityKeyServices = endpointDescriptionArray;
            return this;
        }

        @Override
        public UnsignedInteger getMaxNetworkMessageSize() {
            return this.f_maxNetworkMessageSize;
        }

        @Override
        public Builder setMaxNetworkMessageSize(UnsignedInteger unsignedInteger) {
            this.f_maxNetworkMessageSize = unsignedInteger;
            return this;
        }

        @Override
        public KeyValuePair[] getGroupProperties() {
            return this.f_groupProperties;
        }

        @Override
        public Builder setGroupProperties(KeyValuePair[] keyValuePairArray) {
            this.f_groupProperties = keyValuePairArray;
            return this;
        }

        public ExtensionObject getTransportSettings() {
            return this.f_transportSettings;
        }

        public Builder setTransportSettings(ExtensionObject extensionObject) {
            this.f_transportSettings = extensionObject;
            return this;
        }

        public ExtensionObject getMessageSettings() {
            return this.f_messageSettings;
        }

        public Builder setMessageSettings(ExtensionObject extensionObject) {
            this.f_messageSettings = extensionObject;
            return this;
        }

        public DataSetReaderDataType[] getDataSetReaders() {
            return this.f_dataSetReaders;
        }

        public Builder setDataSetReaders(DataSetReaderDataType[] dataSetReaderDataTypeArray) {
            this.f_dataSetReaders = dataSetReaderDataTypeArray;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getEnabled(), builder.getEnabled())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), builder.getSecurityMode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityGroupId(), builder.getSecurityGroupId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityKeyServices(), builder.getSecurityKeyServices())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getMaxNetworkMessageSize(), builder.getMaxNetworkMessageSize())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getGroupProperties(), builder.getGroupProperties())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTransportSettings(), builder.getTransportSettings())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getMessageSettings(), builder.getMessageSettings())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getDataSetReaders(), builder.getDataSetReaders());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getName(), this.getEnabled(), this.getSecurityMode(), this.getSecurityGroupId(), this.getSecurityKeyServices(), this.getMaxNetworkMessageSize(), this.getGroupProperties(), this.getTransportSettings(), this.getMessageSettings(), this.getDataSetReaders());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.Enabled.equals(fieldSpecification)) {
                return this.getEnabled();
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                return this.getSecurityMode();
            }
            if (Fields.SecurityGroupId.equals(fieldSpecification)) {
                return this.getSecurityGroupId();
            }
            if (Fields.SecurityKeyServices.equals(fieldSpecification)) {
                return this.getSecurityKeyServices();
            }
            if (Fields.MaxNetworkMessageSize.equals(fieldSpecification)) {
                return this.getMaxNetworkMessageSize();
            }
            if (Fields.GroupProperties.equals(fieldSpecification)) {
                return this.getGroupProperties();
            }
            if (Fields.TransportSettings.equals(fieldSpecification)) {
                return this.getTransportSettings();
            }
            if (Fields.MessageSettings.equals(fieldSpecification)) {
                return this.getMessageSettings();
            }
            if (Fields.DataSetReaders.equals(fieldSpecification)) {
                return this.getDataSetReaders();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.Enabled.equals(fieldSpecification)) {
                this.setEnabled((Boolean)object);
                return this;
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.SecurityGroupId.equals(fieldSpecification)) {
                this.setSecurityGroupId((String)object);
                return this;
            }
            if (Fields.SecurityKeyServices.equals(fieldSpecification)) {
                this.setSecurityKeyServices((EndpointDescription[])object);
                return this;
            }
            if (Fields.MaxNetworkMessageSize.equals(fieldSpecification)) {
                this.setMaxNetworkMessageSize((UnsignedInteger)object);
                return this;
            }
            if (Fields.GroupProperties.equals(fieldSpecification)) {
                this.setGroupProperties((KeyValuePair[])object);
                return this;
            }
            if (Fields.TransportSettings.equals(fieldSpecification)) {
                this.setTransportSettings((ExtensionObject)object);
                return this;
            }
            if (Fields.MessageSettings.equals(fieldSpecification)) {
                this.setMessageSettings((ExtensionObject)object);
                return this;
            }
            if (Fields.DataSetReaders.equals(fieldSpecification)) {
                this.setDataSetReaders((DataSetReaderDataType[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_transportSettings = null;
            this.f_messageSettings = null;
            this.f_dataSetReaders = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ReaderGroupDataType build() {
            return new ReaderGroupDataType(this.f_name, this.f_enabled, this.f_securityMode, this.f_securityGroupId, this.f_securityKeyServices, this.f_maxNetworkMessageSize, this.f_groupProperties, this.f_transportSettings, this.f_messageSettings, this.f_dataSetReaders);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Name("Name", String.class, false, UaIds.String, -1, null, false),
        Enabled("Enabled", Boolean.class, false, UaIds.Boolean, -1, null, false),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false),
        SecurityGroupId("SecurityGroupId", String.class, false, UaIds.String, -1, null, false),
        SecurityKeyServices("SecurityKeyServices", EndpointDescription[].class, false, UaIds.EndpointDescription, 1, UaArrayDimensions.valueOf(0L), false),
        MaxNetworkMessageSize("MaxNetworkMessageSize", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        GroupProperties("GroupProperties", KeyValuePair[].class, false, UaIds.KeyValuePair, 1, UaArrayDimensions.valueOf(0L), false),
        TransportSettings("TransportSettings", ExtensionObject.class, false, UaIds.ReaderGroupTransportDataType, -1, null, true),
        MessageSettings("MessageSettings", ExtensionObject.class, false, UaIds.ReaderGroupMessageDataType, -1, null, true),
        DataSetReaders("DataSetReaders", DataSetReaderDataType[].class, false, UaIds.DataSetReaderDataType, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

