/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=626")
public class ReadValueId
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadValueId_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadValueId_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadValueId_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadValueId;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_nodeId;
    private UnsignedInteger f_attributeId;
    private String f_indexRange;
    private QualifiedName f_dataEncoding;

    public ReadValueId() {
    }

    public ReadValueId(NodeId nodeId, UnsignedInteger unsignedInteger, String string, QualifiedName qualifiedName) {
        this.f_nodeId = nodeId;
        this.f_attributeId = unsignedInteger;
        this.f_indexRange = string;
        this.f_dataEncoding = qualifiedName;
    }

    public NodeId getNodeId() {
        return this.f_nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.f_nodeId = nodeId;
    }

    public UnsignedInteger getAttributeId() {
        return this.f_attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.f_attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.f_indexRange;
    }

    public void setIndexRange(String string) {
        this.f_indexRange = string;
    }

    public QualifiedName getDataEncoding() {
        return this.f_dataEncoding;
    }

    public void setDataEncoding(QualifiedName qualifiedName) {
        this.f_dataEncoding = qualifiedName;
    }

    @Override
    public ReadValueId clone() {
        ReadValueId readValueId = (ReadValueId)super.clone();
        readValueId.f_nodeId = StructureUtils.clone(this.f_nodeId);
        readValueId.f_attributeId = StructureUtils.clone(this.f_attributeId);
        readValueId.f_indexRange = StructureUtils.clone(this.f_indexRange);
        readValueId.f_dataEncoding = StructureUtils.clone(this.f_dataEncoding);
        return readValueId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadValueId readValueId = (ReadValueId)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), readValueId.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), readValueId.getAttributeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIndexRange(), readValueId.getIndexRange())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDataEncoding(), readValueId.getDataEncoding());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getAttributeId(), this.getIndexRange(), this.getDataEncoding());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_nodeId = null;
        this.f_attributeId = null;
        this.f_indexRange = null;
        this.f_dataEncoding = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.NodeId, this.getNodeId());
        linkedHashMap.put(Fields.AttributeId, this.getAttributeId());
        linkedHashMap.put(Fields.IndexRange, this.getIndexRange());
        linkedHashMap.put(Fields.DataEncoding, this.getDataEncoding());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.AttributeId.equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        if (Fields.DataEncoding.equals(fieldSpecification)) {
            return this.getDataEncoding();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.AttributeId.equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        if (Fields.DataEncoding.equals(fieldSpecification)) {
            this.setDataEncoding((QualifiedName)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadValueId.builder();
        builder.setNodeId(StructureUtils.clone(this.getNodeId()));
        builder.setAttributeId(StructureUtils.clone(this.getAttributeId()));
        builder.setIndexRange(StructureUtils.clone(this.getIndexRange()));
        builder.setDataEncoding(StructureUtils.clone(this.getDataEncoding()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId);
        builder.addField(Fields.AttributeId);
        builder.addField(Fields.IndexRange);
        builder.addField(Fields.DataEncoding);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ReadValueId");
        builder.setJavaClass(ReadValueId.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId f_nodeId;
        private UnsignedInteger f_attributeId;
        private String f_indexRange;
        private QualifiedName f_dataEncoding;

        protected Builder() {
        }

        public NodeId getNodeId() {
            return this.f_nodeId;
        }

        public Builder setNodeId(NodeId nodeId) {
            this.f_nodeId = nodeId;
            return this;
        }

        public UnsignedInteger getAttributeId() {
            return this.f_attributeId;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.f_attributeId = unsignedInteger;
            return this;
        }

        public String getIndexRange() {
            return this.f_indexRange;
        }

        public Builder setIndexRange(String string) {
            this.f_indexRange = string;
            return this;
        }

        public QualifiedName getDataEncoding() {
            return this.f_dataEncoding;
        }

        public Builder setDataEncoding(QualifiedName qualifiedName) {
            this.f_dataEncoding = qualifiedName;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), builder.getNodeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), builder.getAttributeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getIndexRange(), builder.getIndexRange())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getDataEncoding(), builder.getDataEncoding());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getNodeId(), this.getAttributeId(), this.getIndexRange(), this.getDataEncoding());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.NodeId.equals(fieldSpecification)) {
                return this.getNodeId();
            }
            if (Fields.AttributeId.equals(fieldSpecification)) {
                return this.getAttributeId();
            }
            if (Fields.IndexRange.equals(fieldSpecification)) {
                return this.getIndexRange();
            }
            if (Fields.DataEncoding.equals(fieldSpecification)) {
                return this.getDataEncoding();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.AttributeId.equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            if (Fields.DataEncoding.equals(fieldSpecification)) {
                this.setDataEncoding((QualifiedName)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_nodeId = null;
            this.f_attributeId = null;
            this.f_indexRange = null;
            this.f_dataEncoding = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ReadValueId build() {
            return new ReadValueId(this.f_nodeId, this.f_attributeId, this.f_indexRange, this.f_dataEncoding);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        NodeId("NodeId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false),
        IndexRange("IndexRange", String.class, false, UaIds.NumericRange, -1, null, false),
        DataEncoding("DataEncoding", QualifiedName.class, false, UaIds.QualifiedName, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

