/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=644")
public class ReadEventDetails
extends HistoryReadDetails {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadEventDetails_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadEventDetails_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadEventDetails_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadEventDetails;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger f_numValuesPerNode;
    private DateTime f_startTime;
    private DateTime f_endTime;
    private EventFilter f_filter;

    public ReadEventDetails() {
    }

    public ReadEventDetails(UnsignedInteger unsignedInteger, DateTime dateTime, DateTime dateTime2, EventFilter eventFilter) {
        this.f_numValuesPerNode = unsignedInteger;
        this.f_startTime = dateTime;
        this.f_endTime = dateTime2;
        this.f_filter = eventFilter;
    }

    public UnsignedInteger getNumValuesPerNode() {
        return this.f_numValuesPerNode;
    }

    public void setNumValuesPerNode(UnsignedInteger unsignedInteger) {
        this.f_numValuesPerNode = unsignedInteger;
    }

    public DateTime getStartTime() {
        return this.f_startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.f_startTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.f_endTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.f_endTime = dateTime;
    }

    public EventFilter getFilter() {
        return this.f_filter;
    }

    public void setFilter(EventFilter eventFilter) {
        this.f_filter = eventFilter;
    }

    @Override
    public ReadEventDetails clone() {
        ReadEventDetails readEventDetails = (ReadEventDetails)super.clone();
        readEventDetails.f_numValuesPerNode = StructureUtils.clone(this.f_numValuesPerNode);
        readEventDetails.f_startTime = StructureUtils.clone(this.f_startTime);
        readEventDetails.f_endTime = StructureUtils.clone(this.f_endTime);
        readEventDetails.f_filter = StructureUtils.clone(this.f_filter);
        return readEventDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadEventDetails readEventDetails = (ReadEventDetails)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNumValuesPerNode(), readEventDetails.getNumValuesPerNode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), readEventDetails.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEndTime(), readEventDetails.getEndTime())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilter(), readEventDetails.getFilter());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNumValuesPerNode(), this.getStartTime(), this.getEndTime(), this.getFilter());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_numValuesPerNode = null;
        this.f_startTime = null;
        this.f_endTime = null;
        this.f_filter = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.NumValuesPerNode, this.getNumValuesPerNode());
        linkedHashMap.put(Fields.StartTime, this.getStartTime());
        linkedHashMap.put(Fields.EndTime, this.getEndTime());
        linkedHashMap.put(Fields.Filter, this.getFilter());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NumValuesPerNode.equals(fieldSpecification)) {
            return this.getNumValuesPerNode();
        }
        if (Fields.StartTime.equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.EndTime.equals(fieldSpecification)) {
            return this.getEndTime();
        }
        if (Fields.Filter.equals(fieldSpecification)) {
            return this.getFilter();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NumValuesPerNode.equals(fieldSpecification)) {
            this.setNumValuesPerNode((UnsignedInteger)object);
            return;
        }
        if (Fields.StartTime.equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.EndTime.equals(fieldSpecification)) {
            this.setEndTime((DateTime)object);
            return;
        }
        if (Fields.Filter.equals(fieldSpecification)) {
            this.setFilter((EventFilter)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadEventDetails.builder();
        builder.setNumValuesPerNode(StructureUtils.clone(this.getNumValuesPerNode()));
        builder.setStartTime(StructureUtils.clone(this.getStartTime()));
        builder.setEndTime(StructureUtils.clone(this.getEndTime()));
        builder.setFilter(StructureUtils.clone(this.getFilter()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.NumValuesPerNode);
        builder.addField(Fields.StartTime);
        builder.addField(Fields.EndTime);
        builder.addField(Fields.Filter);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.HistoryReadDetails);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ReadEventDetails");
        builder.setJavaClass(ReadEventDetails.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryReadDetails.Builder {
        private UnsignedInteger f_numValuesPerNode;
        private DateTime f_startTime;
        private DateTime f_endTime;
        private EventFilter f_filter;

        protected Builder() {
        }

        public UnsignedInteger getNumValuesPerNode() {
            return this.f_numValuesPerNode;
        }

        public Builder setNumValuesPerNode(UnsignedInteger unsignedInteger) {
            this.f_numValuesPerNode = unsignedInteger;
            return this;
        }

        public DateTime getStartTime() {
            return this.f_startTime;
        }

        public Builder setStartTime(DateTime dateTime) {
            this.f_startTime = dateTime;
            return this;
        }

        public DateTime getEndTime() {
            return this.f_endTime;
        }

        public Builder setEndTime(DateTime dateTime) {
            this.f_endTime = dateTime;
            return this;
        }

        public EventFilter getFilter() {
            return this.f_filter;
        }

        public Builder setFilter(EventFilter eventFilter) {
            this.f_filter = eventFilter;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNumValuesPerNode(), builder.getNumValuesPerNode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), builder.getStartTime())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getEndTime(), builder.getEndTime())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getFilter(), builder.getFilter());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getNumValuesPerNode(), this.getStartTime(), this.getEndTime(), this.getFilter());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.NumValuesPerNode.equals(fieldSpecification)) {
                return this.getNumValuesPerNode();
            }
            if (Fields.StartTime.equals(fieldSpecification)) {
                return this.getStartTime();
            }
            if (Fields.EndTime.equals(fieldSpecification)) {
                return this.getEndTime();
            }
            if (Fields.Filter.equals(fieldSpecification)) {
                return this.getFilter();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NumValuesPerNode.equals(fieldSpecification)) {
                this.setNumValuesPerNode((UnsignedInteger)object);
                return this;
            }
            if (Fields.StartTime.equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.EndTime.equals(fieldSpecification)) {
                this.setEndTime((DateTime)object);
                return this;
            }
            if (Fields.Filter.equals(fieldSpecification)) {
                this.setFilter((EventFilter)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_numValuesPerNode = null;
            this.f_startTime = null;
            this.f_endTime = null;
            this.f_filter = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ReadEventDetails build() {
            return new ReadEventDetails(this.f_numValuesPerNode, this.f_startTime, this.f_endTime, this.f_filter);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        NumValuesPerNode("NumValuesPerNode", UnsignedInteger.class, false, UaIds.Counter, -1, null, false),
        StartTime("StartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        EndTime("EndTime", DateTime.class, false, UaIds.UtcTime, -1, null, false),
        Filter("Filter", EventFilter.class, false, UaIds.EventFilter, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

