/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18806")
public class RationalNumber
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RationalNumber_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RationalNumber_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RationalNumber_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RationalNumber;
    public static final StructureSpecification SPECIFICATION;
    private Integer f_numerator;
    private UnsignedInteger f_denominator;

    public RationalNumber() {
    }

    public RationalNumber(Integer n2, UnsignedInteger unsignedInteger) {
        this.f_numerator = n2;
        this.f_denominator = unsignedInteger;
    }

    public Integer getNumerator() {
        return this.f_numerator;
    }

    public void setNumerator(Integer n2) {
        this.f_numerator = n2;
    }

    public UnsignedInteger getDenominator() {
        return this.f_denominator;
    }

    public void setDenominator(UnsignedInteger unsignedInteger) {
        this.f_denominator = unsignedInteger;
    }

    @Override
    public RationalNumber clone() {
        RationalNumber rationalNumber = (RationalNumber)super.clone();
        rationalNumber.f_numerator = StructureUtils.clone(this.f_numerator);
        rationalNumber.f_denominator = StructureUtils.clone(this.f_denominator);
        return rationalNumber;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RationalNumber rationalNumber = (RationalNumber)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNumerator(), rationalNumber.getNumerator())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDenominator(), rationalNumber.getDenominator());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNumerator(), this.getDenominator());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_numerator = null;
        this.f_denominator = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Number> linkedHashMap = new LinkedHashMap<Fields, Number>();
        linkedHashMap.put(Fields.Numerator, this.getNumerator());
        linkedHashMap.put(Fields.Denominator, this.getDenominator());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Numerator.equals(fieldSpecification)) {
            return this.getNumerator();
        }
        if (Fields.Denominator.equals(fieldSpecification)) {
            return this.getDenominator();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Numerator.equals(fieldSpecification)) {
            this.setNumerator((Integer)object);
            return;
        }
        if (Fields.Denominator.equals(fieldSpecification)) {
            this.setDenominator((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RationalNumber.builder();
        builder.setNumerator(StructureUtils.clone(this.getNumerator()));
        builder.setDenominator(StructureUtils.clone(this.getDenominator()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Numerator);
        builder.addField(Fields.Denominator);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("RationalNumber");
        builder.setJavaClass(RationalNumber.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Integer f_numerator;
        private UnsignedInteger f_denominator;

        protected Builder() {
        }

        public Integer getNumerator() {
            return this.f_numerator;
        }

        public Builder setNumerator(Integer n2) {
            this.f_numerator = n2;
            return this;
        }

        public UnsignedInteger getDenominator() {
            return this.f_denominator;
        }

        public Builder setDenominator(UnsignedInteger unsignedInteger) {
            this.f_denominator = unsignedInteger;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNumerator(), builder.getNumerator())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getDenominator(), builder.getDenominator());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getNumerator(), this.getDenominator());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Numerator.equals(fieldSpecification)) {
                return this.getNumerator();
            }
            if (Fields.Denominator.equals(fieldSpecification)) {
                return this.getDenominator();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Numerator.equals(fieldSpecification)) {
                this.setNumerator((Integer)object);
                return this;
            }
            if (Fields.Denominator.equals(fieldSpecification)) {
                this.setDenominator((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_numerator = null;
            this.f_denominator = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public RationalNumber build() {
            return new RationalNumber(this.f_numerator, this.f_denominator);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Numerator("Numerator", Integer.class, false, UaIds.Int32, -1, null, false),
        Denominator("Denominator", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

