/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=884")
public class Range
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.Range_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.Range_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.Range_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.Range;
    public static final StructureSpecification SPECIFICATION;
    private Double f_low;
    private Double f_high;

    public Range() {
    }

    public Range(Double d2, Double d3) {
        this.f_low = d2;
        this.f_high = d3;
    }

    public Double getLow() {
        return this.f_low;
    }

    public void setLow(Double d2) {
        this.f_low = d2;
    }

    public Double getHigh() {
        return this.f_high;
    }

    public void setHigh(Double d2) {
        this.f_high = d2;
    }

    @Override
    public Range clone() {
        Range range = (Range)super.clone();
        range.f_low = StructureUtils.clone(this.f_low);
        range.f_high = StructureUtils.clone(this.f_high);
        return range;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getLow(), range.getLow())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getHigh(), range.getHigh());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getLow(), this.getHigh());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_low = null;
        this.f_high = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Double> linkedHashMap = new LinkedHashMap<Fields, Double>();
        linkedHashMap.put(Fields.Low, this.getLow());
        linkedHashMap.put(Fields.High, this.getHigh());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Low.equals(fieldSpecification)) {
            return this.getLow();
        }
        if (Fields.High.equals(fieldSpecification)) {
            return this.getHigh();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Low.equals(fieldSpecification)) {
            this.setLow((Double)object);
            return;
        }
        if (Fields.High.equals(fieldSpecification)) {
            this.setHigh((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Range.builder();
        builder.setLow(StructureUtils.clone(this.getLow()));
        builder.setHigh(StructureUtils.clone(this.getHigh()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Low);
        builder.addField(Fields.High);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("Range");
        builder.setJavaClass(Range.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double f_low;
        private Double f_high;

        protected Builder() {
        }

        public Double getLow() {
            return this.f_low;
        }

        public Builder setLow(Double d2) {
            this.f_low = d2;
            return this;
        }

        public Double getHigh() {
            return this.f_high;
        }

        public Builder setHigh(Double d2) {
            this.f_high = d2;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getLow(), builder.getLow())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getHigh(), builder.getHigh());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getLow(), this.getHigh());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Low.equals(fieldSpecification)) {
                return this.getLow();
            }
            if (Fields.High.equals(fieldSpecification)) {
                return this.getHigh();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Low.equals(fieldSpecification)) {
                this.setLow((Double)object);
                return this;
            }
            if (Fields.High.equals(fieldSpecification)) {
                this.setHigh((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_low = null;
            this.f_high = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public Range build() {
            return new Range(this.f_low, this.f_high);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Low("Low", Double.class, false, UaIds.Double, -1, null, false),
        High("High", Double.class, false, UaIds.Double, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

