/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=570")
public class QueryDataDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryDataDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryDataDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryDataDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryDataDescription;
    public static final StructureSpecification SPECIFICATION;
    private RelativePath f_relativePath;
    private UnsignedInteger f_attributeId;
    private String f_indexRange;

    public QueryDataDescription() {
    }

    public QueryDataDescription(RelativePath relativePath, UnsignedInteger unsignedInteger, String string) {
        this.f_relativePath = relativePath;
        this.f_attributeId = unsignedInteger;
        this.f_indexRange = string;
    }

    public RelativePath getRelativePath() {
        return this.f_relativePath;
    }

    public void setRelativePath(RelativePath relativePath) {
        this.f_relativePath = relativePath;
    }

    public UnsignedInteger getAttributeId() {
        return this.f_attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.f_attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.f_indexRange;
    }

    public void setIndexRange(String string) {
        this.f_indexRange = string;
    }

    @Override
    public QueryDataDescription clone() {
        QueryDataDescription queryDataDescription = (QueryDataDescription)super.clone();
        queryDataDescription.f_relativePath = StructureUtils.clone(this.f_relativePath);
        queryDataDescription.f_attributeId = StructureUtils.clone(this.f_attributeId);
        queryDataDescription.f_indexRange = StructureUtils.clone(this.f_indexRange);
        return queryDataDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryDataDescription queryDataDescription = (QueryDataDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRelativePath(), queryDataDescription.getRelativePath())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), queryDataDescription.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIndexRange(), queryDataDescription.getIndexRange());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRelativePath(), this.getAttributeId(), this.getIndexRange());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_relativePath = null;
        this.f_attributeId = null;
        this.f_indexRange = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.RelativePath, this.getRelativePath());
        linkedHashMap.put(Fields.AttributeId, this.getAttributeId());
        linkedHashMap.put(Fields.IndexRange, this.getIndexRange());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RelativePath.equals(fieldSpecification)) {
            return this.getRelativePath();
        }
        if (Fields.AttributeId.equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RelativePath.equals(fieldSpecification)) {
            this.setRelativePath((RelativePath)object);
            return;
        }
        if (Fields.AttributeId.equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryDataDescription.builder();
        builder.setRelativePath(StructureUtils.clone(this.getRelativePath()));
        builder.setAttributeId(StructureUtils.clone(this.getAttributeId()));
        builder.setIndexRange(StructureUtils.clone(this.getIndexRange()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RelativePath);
        builder.addField(Fields.AttributeId);
        builder.addField(Fields.IndexRange);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("QueryDataDescription");
        builder.setJavaClass(QueryDataDescription.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RelativePath f_relativePath;
        private UnsignedInteger f_attributeId;
        private String f_indexRange;

        protected Builder() {
        }

        public RelativePath getRelativePath() {
            return this.f_relativePath;
        }

        public Builder setRelativePath(RelativePath relativePath) {
            this.f_relativePath = relativePath;
            return this;
        }

        public UnsignedInteger getAttributeId() {
            return this.f_attributeId;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.f_attributeId = unsignedInteger;
            return this;
        }

        public String getIndexRange() {
            return this.f_indexRange;
        }

        public Builder setIndexRange(String string) {
            this.f_indexRange = string;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getRelativePath(), builder.getRelativePath())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), builder.getAttributeId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getIndexRange(), builder.getIndexRange());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getRelativePath(), this.getAttributeId(), this.getIndexRange());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.RelativePath.equals(fieldSpecification)) {
                return this.getRelativePath();
            }
            if (Fields.AttributeId.equals(fieldSpecification)) {
                return this.getAttributeId();
            }
            if (Fields.IndexRange.equals(fieldSpecification)) {
                return this.getIndexRange();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RelativePath.equals(fieldSpecification)) {
                this.setRelativePath((RelativePath)object);
                return this;
            }
            if (Fields.AttributeId.equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_relativePath = null;
            this.f_attributeId = null;
            this.f_indexRange = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public QueryDataDescription build() {
            return new QueryDataDescription(this.f_relativePath, this.f_attributeId, this.f_indexRange);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RelativePath("RelativePath", RelativePath.class, false, UaIds.RelativePath, -1, null, false),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false),
        IndexRange("IndexRange", String.class, false, UaIds.NumericRange, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

