/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24106")
public class PortableNodeId
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.PortableNodeId_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.PortableNodeId_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.PortableNodeId_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.PortableNodeId;
    public static final StructureSpecification SPECIFICATION;
    private String f_namespaceUri;
    private NodeId f_identifier;

    public PortableNodeId() {
    }

    public PortableNodeId(String string, NodeId nodeId) {
        this.f_namespaceUri = string;
        this.f_identifier = nodeId;
    }

    public String getNamespaceUri() {
        return this.f_namespaceUri;
    }

    public void setNamespaceUri(String string) {
        this.f_namespaceUri = string;
    }

    public NodeId getIdentifier() {
        return this.f_identifier;
    }

    public void setIdentifier(NodeId nodeId) {
        this.f_identifier = nodeId;
    }

    @Override
    public PortableNodeId clone() {
        PortableNodeId portableNodeId = (PortableNodeId)super.clone();
        portableNodeId.f_namespaceUri = StructureUtils.clone(this.f_namespaceUri);
        portableNodeId.f_identifier = StructureUtils.clone(this.f_identifier);
        return portableNodeId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PortableNodeId portableNodeId = (PortableNodeId)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaceUri(), portableNodeId.getNamespaceUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIdentifier(), portableNodeId.getIdentifier());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaceUri(), this.getIdentifier());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_namespaceUri = null;
        this.f_identifier = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.NamespaceUri, this.getNamespaceUri());
        linkedHashMap.put(Fields.Identifier, this.getIdentifier());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NamespaceUri.equals(fieldSpecification)) {
            return this.getNamespaceUri();
        }
        if (Fields.Identifier.equals(fieldSpecification)) {
            return this.getIdentifier();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NamespaceUri.equals(fieldSpecification)) {
            this.setNamespaceUri((String)object);
            return;
        }
        if (Fields.Identifier.equals(fieldSpecification)) {
            this.setIdentifier((NodeId)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = PortableNodeId.builder();
        builder.setNamespaceUri(StructureUtils.clone(this.getNamespaceUri()));
        builder.setIdentifier(StructureUtils.clone(this.getIdentifier()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.NamespaceUri);
        builder.addField(Fields.Identifier);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("PortableNodeId");
        builder.setJavaClass(PortableNodeId.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_namespaceUri;
        private NodeId f_identifier;

        protected Builder() {
        }

        public String getNamespaceUri() {
            return this.f_namespaceUri;
        }

        public Builder setNamespaceUri(String string) {
            this.f_namespaceUri = string;
            return this;
        }

        public NodeId getIdentifier() {
            return this.f_identifier;
        }

        public Builder setIdentifier(NodeId nodeId) {
            this.f_identifier = nodeId;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNamespaceUri(), builder.getNamespaceUri())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getIdentifier(), builder.getIdentifier());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getNamespaceUri(), this.getIdentifier());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.NamespaceUri.equals(fieldSpecification)) {
                return this.getNamespaceUri();
            }
            if (Fields.Identifier.equals(fieldSpecification)) {
                return this.getIdentifier();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NamespaceUri.equals(fieldSpecification)) {
                this.setNamespaceUri((String)object);
                return this;
            }
            if (Fields.Identifier.equals(fieldSpecification)) {
                this.setIdentifier((NodeId)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_namespaceUri = null;
            this.f_identifier = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public PortableNodeId build() {
            return new PortableNodeId(this.f_namespaceUri, this.f_identifier);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        NamespaceUri("NamespaceUri", String.class, false, UaIds.String, -1, null, false),
        Identifier("Identifier", NodeId.class, false, UaIds.NodeId, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

