/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=352")
public class ObjectAttributes
extends NodeAttributes {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ObjectAttributes_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ObjectAttributes_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ObjectAttributes_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ObjectAttributes;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedByte f_eventNotifier;

    public ObjectAttributes() {
    }

    public ObjectAttributes(UnsignedByte unsignedByte) {
        this.f_eventNotifier = unsignedByte;
    }

    public ObjectAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, UnsignedByte unsignedByte) {
        super(unsignedInteger, localizedText, localizedText2, unsignedInteger2, unsignedInteger3);
        this.f_eventNotifier = unsignedByte;
    }

    public UnsignedByte getEventNotifier() {
        return this.f_eventNotifier;
    }

    public void setEventNotifier(UnsignedByte unsignedByte) {
        this.f_eventNotifier = unsignedByte;
    }

    @Override
    public ObjectAttributes clone() {
        ObjectAttributes objectAttributes = (ObjectAttributes)super.clone();
        objectAttributes.f_eventNotifier = StructureUtils.clone(this.f_eventNotifier);
        return objectAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectAttributes objectAttributes = (ObjectAttributes)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), objectAttributes.getSpecifiedAttributes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), objectAttributes.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), objectAttributes.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), objectAttributes.getWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), objectAttributes.getUserWriteMask())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEventNotifier(), objectAttributes.getEventNotifier());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getEventNotifier());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_eventNotifier = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.SpecifiedAttributes, this.getSpecifiedAttributes());
        linkedHashMap.put(Fields.DisplayName, this.getDisplayName());
        linkedHashMap.put(Fields.Description, this.getDescription());
        linkedHashMap.put(Fields.WriteMask, this.getWriteMask());
        linkedHashMap.put(Fields.UserWriteMask, this.getUserWriteMask());
        linkedHashMap.put(Fields.EventNotifier, this.getEventNotifier());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
            return this.getSpecifiedAttributes();
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.WriteMask.equals(fieldSpecification)) {
            return this.getWriteMask();
        }
        if (Fields.UserWriteMask.equals(fieldSpecification)) {
            return this.getUserWriteMask();
        }
        if (Fields.EventNotifier.equals(fieldSpecification)) {
            return this.getEventNotifier();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
            this.setSpecifiedAttributes((UnsignedInteger)object);
            return;
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.WriteMask.equals(fieldSpecification)) {
            this.setWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.UserWriteMask.equals(fieldSpecification)) {
            this.setUserWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.EventNotifier.equals(fieldSpecification)) {
            this.setEventNotifier((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ObjectAttributes.builder();
        builder.setSpecifiedAttributes(StructureUtils.clone(this.getSpecifiedAttributes()));
        builder.setDisplayName(StructureUtils.clone(this.getDisplayName()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        builder.setWriteMask(StructureUtils.clone(this.getWriteMask()));
        builder.setUserWriteMask(StructureUtils.clone(this.getUserWriteMask()));
        builder.setEventNotifier(StructureUtils.clone(this.getEventNotifier()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedAttributes);
        builder.addField(Fields.DisplayName);
        builder.addField(Fields.Description);
        builder.addField(Fields.WriteMask);
        builder.addField(Fields.UserWriteMask);
        builder.addField(Fields.EventNotifier);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.NodeAttributes);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ObjectAttributes");
        builder.setJavaClass(ObjectAttributes.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NodeAttributes.Builder {
        private UnsignedInteger f_specifiedAttributes;
        private LocalizedText f_displayName;
        private LocalizedText f_description;
        private UnsignedInteger f_writeMask;
        private UnsignedInteger f_userWriteMask;
        private UnsignedByte f_eventNotifier;

        protected Builder() {
        }

        @Override
        public UnsignedInteger getSpecifiedAttributes() {
            return this.f_specifiedAttributes;
        }

        @Override
        public Builder setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
            this.f_specifiedAttributes = unsignedInteger;
            return this;
        }

        @Override
        public LocalizedText getDisplayName() {
            return this.f_displayName;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.f_displayName = localizedText;
            return this;
        }

        @Override
        public LocalizedText getDescription() {
            return this.f_description;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        @Override
        public UnsignedInteger getWriteMask() {
            return this.f_writeMask;
        }

        @Override
        public Builder setWriteMask(UnsignedInteger unsignedInteger) {
            this.f_writeMask = unsignedInteger;
            return this;
        }

        @Override
        public UnsignedInteger getUserWriteMask() {
            return this.f_userWriteMask;
        }

        @Override
        public Builder setUserWriteMask(UnsignedInteger unsignedInteger) {
            this.f_userWriteMask = unsignedInteger;
            return this;
        }

        public UnsignedByte getEventNotifier() {
            return this.f_eventNotifier;
        }

        public Builder setEventNotifier(UnsignedByte unsignedByte) {
            this.f_eventNotifier = unsignedByte;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), builder.getSpecifiedAttributes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), builder.getDisplayName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), builder.getWriteMask())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), builder.getUserWriteMask())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getEventNotifier(), builder.getEventNotifier());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getEventNotifier());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
                return this.getSpecifiedAttributes();
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                return this.getDisplayName();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            if (Fields.WriteMask.equals(fieldSpecification)) {
                return this.getWriteMask();
            }
            if (Fields.UserWriteMask.equals(fieldSpecification)) {
                return this.getUserWriteMask();
            }
            if (Fields.EventNotifier.equals(fieldSpecification)) {
                return this.getEventNotifier();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedAttributes.equals(fieldSpecification)) {
                this.setSpecifiedAttributes((UnsignedInteger)object);
                return this;
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.WriteMask.equals(fieldSpecification)) {
                this.setWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.UserWriteMask.equals(fieldSpecification)) {
                this.setUserWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.EventNotifier.equals(fieldSpecification)) {
                this.setEventNotifier((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_eventNotifier = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ObjectAttributes build() {
            return new ObjectAttributes(this.f_specifiedAttributes, this.f_displayName, this.f_description, this.f_writeMask, this.f_userWriteMask, this.f_eventNotifier);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SpecifiedAttributes("SpecifiedAttributes", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        DisplayName("DisplayName", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        WriteMask("WriteMask", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        UserWriteMask("UserWriteMask", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        EventNotifier("EventNotifier", UnsignedByte.class, false, UaIds.Byte, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

