/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=580")
public class NodeReference
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NodeReference_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NodeReference_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NodeReference_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NodeReference;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_nodeId;
    private NodeId f_referenceTypeId;
    private Boolean f_isForward;
    private NodeId[] f_referencedNodeIds;

    public NodeReference() {
    }

    public NodeReference(NodeId nodeId, NodeId nodeId2, Boolean bl, NodeId[] nodeIdArray) {
        this.f_nodeId = nodeId;
        this.f_referenceTypeId = nodeId2;
        this.f_isForward = bl;
        this.f_referencedNodeIds = nodeIdArray;
    }

    public NodeId getNodeId() {
        return this.f_nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.f_nodeId = nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.f_referenceTypeId;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.f_referenceTypeId = nodeId;
    }

    public Boolean getIsForward() {
        return this.f_isForward;
    }

    public void setIsForward(Boolean bl) {
        this.f_isForward = bl;
    }

    public NodeId[] getReferencedNodeIds() {
        return this.f_referencedNodeIds;
    }

    public void setReferencedNodeIds(NodeId[] nodeIdArray) {
        this.f_referencedNodeIds = nodeIdArray;
    }

    @Override
    public NodeReference clone() {
        NodeReference nodeReference = (NodeReference)super.clone();
        nodeReference.f_nodeId = StructureUtils.clone(this.f_nodeId);
        nodeReference.f_referenceTypeId = StructureUtils.clone(this.f_referenceTypeId);
        nodeReference.f_isForward = StructureUtils.clone(this.f_isForward);
        nodeReference.f_referencedNodeIds = StructureUtils.clone(this.f_referencedNodeIds);
        return nodeReference;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeReference nodeReference = (NodeReference)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), nodeReference.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReferenceTypeId(), nodeReference.getReferenceTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsForward(), nodeReference.getIsForward())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getReferencedNodeIds(), nodeReference.getReferencedNodeIds());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getReferencedNodeIds());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_nodeId = null;
        this.f_referenceTypeId = null;
        this.f_isForward = null;
        this.f_referencedNodeIds = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.NodeId, this.getNodeId());
        linkedHashMap.put(Fields.ReferenceTypeId, this.getReferenceTypeId());
        linkedHashMap.put(Fields.IsForward, this.getIsForward());
        linkedHashMap.put(Fields.ReferencedNodeIds, this.getReferencedNodeIds());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.ReferenceTypeId.equals(fieldSpecification)) {
            return this.getReferenceTypeId();
        }
        if (Fields.IsForward.equals(fieldSpecification)) {
            return this.getIsForward();
        }
        if (Fields.ReferencedNodeIds.equals(fieldSpecification)) {
            return this.getReferencedNodeIds();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.ReferenceTypeId.equals(fieldSpecification)) {
            this.setReferenceTypeId((NodeId)object);
            return;
        }
        if (Fields.IsForward.equals(fieldSpecification)) {
            this.setIsForward((Boolean)object);
            return;
        }
        if (Fields.ReferencedNodeIds.equals(fieldSpecification)) {
            this.setReferencedNodeIds((NodeId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeReference.builder();
        builder.setNodeId(StructureUtils.clone(this.getNodeId()));
        builder.setReferenceTypeId(StructureUtils.clone(this.getReferenceTypeId()));
        builder.setIsForward(StructureUtils.clone(this.getIsForward()));
        builder.setReferencedNodeIds(StructureUtils.clone(this.getReferencedNodeIds()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId);
        builder.addField(Fields.ReferenceTypeId);
        builder.addField(Fields.IsForward);
        builder.addField(Fields.ReferencedNodeIds);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("NodeReference");
        builder.setJavaClass(NodeReference.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId f_nodeId;
        private NodeId f_referenceTypeId;
        private Boolean f_isForward;
        private NodeId[] f_referencedNodeIds;

        protected Builder() {
        }

        public NodeId getNodeId() {
            return this.f_nodeId;
        }

        public Builder setNodeId(NodeId nodeId) {
            this.f_nodeId = nodeId;
            return this;
        }

        public NodeId getReferenceTypeId() {
            return this.f_referenceTypeId;
        }

        public Builder setReferenceTypeId(NodeId nodeId) {
            this.f_referenceTypeId = nodeId;
            return this;
        }

        public Boolean getIsForward() {
            return this.f_isForward;
        }

        public Builder setIsForward(Boolean bl) {
            this.f_isForward = bl;
            return this;
        }

        public NodeId[] getReferencedNodeIds() {
            return this.f_referencedNodeIds;
        }

        public Builder setReferencedNodeIds(NodeId[] nodeIdArray) {
            this.f_referencedNodeIds = nodeIdArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), builder.getNodeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getReferenceTypeId(), builder.getReferenceTypeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getIsForward(), builder.getIsForward())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getReferencedNodeIds(), builder.getReferencedNodeIds());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getReferencedNodeIds());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.NodeId.equals(fieldSpecification)) {
                return this.getNodeId();
            }
            if (Fields.ReferenceTypeId.equals(fieldSpecification)) {
                return this.getReferenceTypeId();
            }
            if (Fields.IsForward.equals(fieldSpecification)) {
                return this.getIsForward();
            }
            if (Fields.ReferencedNodeIds.equals(fieldSpecification)) {
                return this.getReferencedNodeIds();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.ReferenceTypeId.equals(fieldSpecification)) {
                this.setReferenceTypeId((NodeId)object);
                return this;
            }
            if (Fields.IsForward.equals(fieldSpecification)) {
                this.setIsForward((Boolean)object);
                return this;
            }
            if (Fields.ReferencedNodeIds.equals(fieldSpecification)) {
                this.setReferencedNodeIds((NodeId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_nodeId = null;
            this.f_referenceTypeId = null;
            this.f_isForward = null;
            this.f_referencedNodeIds = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public NodeReference build() {
            return new NodeReference(this.f_nodeId, this.f_referenceTypeId, this.f_isForward, this.f_referencedNodeIds);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        NodeId("NodeId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        ReferenceTypeId("ReferenceTypeId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        IsForward("IsForward", Boolean.class, false, UaIds.Boolean, -1, null, false),
        ReferencedNodeIds("ReferencedNodeIds", NodeId[].class, false, UaIds.NodeId, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

