/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=348")
public enum NodeAttributesMask implements Enumeration
{
    None(0),
    AccessLevel(1),
    ArrayDimensions(2),
    BrowseName(4),
    ContainsNoLoops(8),
    DataType(16),
    Description(32),
    DisplayName(64),
    EventNotifier(128),
    Executable(256),
    Historizing(512),
    InverseName(1024),
    IsAbstract(2048),
    MinimumSamplingInterval(4096),
    NodeClass(8192),
    NodeId(16384),
    Symmetric(32768),
    UserAccessLevel(65536),
    UserExecutable(131072),
    UserWriteMask(262144),
    ValueRank(524288),
    WriteMask(0x100000),
    Value(0x200000),
    DataTypeDefinition(0x400000),
    RolePermissions(0x800000),
    AccessRestrictions(0x1000000),
    All(0x1FFFFFF),
    BaseNode(26501220),
    Object(26501348),
    ObjectType(26503268),
    Variable(26571383),
    VariableType(28600438),
    Method(26632548),
    ReferenceType(26537060),
    View(26501356);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<NodeAttributesMask> NONE;
    public static final EnumSet<NodeAttributesMask> ALL;
    private static final Map<Integer, NodeAttributesMask> map;
    private final int value;

    private NodeAttributesMask(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static NodeAttributesMask valueOf(int n2) {
        return map.get(n2);
    }

    public static NodeAttributesMask valueOf(Integer n2) {
        return n2 == null ? null : NodeAttributesMask.valueOf((int)n2);
    }

    public static NodeAttributesMask valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : NodeAttributesMask.valueOf(unsignedInteger.intValue());
    }

    public static NodeAttributesMask[] valueOf(int[] nArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nodeAttributesMaskArray[i2] = NodeAttributesMask.valueOf(nArray[i2]);
        }
        return nodeAttributesMaskArray;
    }

    public static NodeAttributesMask[] valueOf(Integer[] integerArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nodeAttributesMaskArray[i2] = NodeAttributesMask.valueOf(integerArray[i2]);
        }
        return nodeAttributesMaskArray;
    }

    public static NodeAttributesMask[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        NodeAttributesMask[] nodeAttributesMaskArray = new NodeAttributesMask[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            nodeAttributesMaskArray[i2] = NodeAttributesMask.valueOf(unsignedIntegerArray[i2]);
        }
        return nodeAttributesMaskArray;
    }

    public static UnsignedInteger getMask(NodeAttributesMask ... nodeAttributesMaskArray) {
        int n2 = 0;
        for (NodeAttributesMask nodeAttributesMask : nodeAttributesMaskArray) {
            n2 |= nodeAttributesMask.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<NodeAttributesMask> collection) {
        int n2 = 0;
        for (NodeAttributesMask nodeAttributesMask : collection) {
            n2 |= nodeAttributesMask.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<NodeAttributesMask> getSet(UnsignedInteger unsignedInteger) {
        return NodeAttributesMask.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<NodeAttributesMask> getSet(int n2) {
        ArrayList<NodeAttributesMask> arrayList = new ArrayList<NodeAttributesMask>();
        for (NodeAttributesMask nodeAttributesMask : NodeAttributesMask.values()) {
            if ((n2 & nodeAttributesMask.value) != nodeAttributesMask.value) continue;
            arrayList.add(nodeAttributesMask);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeAttributesMask.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(NodeAttributesMask.class);
        ALL = EnumSet.allOf(NodeAttributesMask.class);
        map = new HashMap<Integer, NodeAttributesMask>();
        for (NodeAttributesMask nodeAttributesMask : NodeAttributesMask.values()) {
            map.put(nodeAttributesMask.value, nodeAttributesMask);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("NodeAttributesMask");
        builder.setJavaClass(NodeAttributesMask.class);
        builder.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=348")));
        builder.addMapping(0, "None");
        builder.addMapping(1, "AccessLevel");
        builder.addMapping(2, "ArrayDimensions");
        builder.addMapping(4, "BrowseName");
        builder.addMapping(8, "ContainsNoLoops");
        builder.addMapping(16, "DataType");
        builder.addMapping(32, "Description");
        builder.addMapping(64, "DisplayName");
        builder.addMapping(128, "EventNotifier");
        builder.addMapping(256, "Executable");
        builder.addMapping(512, "Historizing");
        builder.addMapping(1024, "InverseName");
        builder.addMapping(2048, "IsAbstract");
        builder.addMapping(4096, "MinimumSamplingInterval");
        builder.addMapping(8192, "NodeClass");
        builder.addMapping(16384, "NodeId");
        builder.addMapping(32768, "Symmetric");
        builder.addMapping(65536, "UserAccessLevel");
        builder.addMapping(131072, "UserExecutable");
        builder.addMapping(262144, "UserWriteMask");
        builder.addMapping(524288, "ValueRank");
        builder.addMapping(0x100000, "WriteMask");
        builder.addMapping(0x200000, "Value");
        builder.addMapping(0x400000, "DataTypeDefinition");
        builder.addMapping(0x800000, "RolePermissions");
        builder.addMapping(0x1000000, "AccessRestrictions");
        builder.addMapping(0x1FFFFFF, "All");
        builder.addMapping(26501220, "BaseNode");
        builder.addMapping(26501348, "Object");
        builder.addMapping(26503268, "ObjectType");
        builder.addMapping(26571383, "Variable");
        builder.addMapping(28600438, "VariableType");
        builder.addMapping(26632548, "Method");
        builder.addMapping(26537060, "ReferenceType");
        builder.addMapping(26501356, "View");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return NodeAttributesMask.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private NodeAttributesMask value;

        private Builder() {
        }

        @Override
        public NodeAttributesMask build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = NodeAttributesMask.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum NodeAttributesMask int value: " + n2);
            }
            return this;
        }
    }
}

