/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=743")
public class MonitoredItemCreateRequest
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MonitoredItemCreateRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MonitoredItemCreateRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MonitoredItemCreateRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MonitoredItemCreateRequest;
    public static final StructureSpecification SPECIFICATION;
    private ReadValueId f_itemToMonitor;
    private MonitoringMode f_monitoringMode;
    private MonitoringParameters f_requestedParameters;

    public MonitoredItemCreateRequest() {
    }

    public MonitoredItemCreateRequest(ReadValueId readValueId, MonitoringMode monitoringMode, MonitoringParameters monitoringParameters) {
        this.f_itemToMonitor = readValueId;
        this.f_monitoringMode = monitoringMode;
        this.f_requestedParameters = monitoringParameters;
    }

    public ReadValueId getItemToMonitor() {
        return this.f_itemToMonitor;
    }

    public void setItemToMonitor(ReadValueId readValueId) {
        this.f_itemToMonitor = readValueId;
    }

    public MonitoringMode getMonitoringMode() {
        return this.f_monitoringMode;
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) {
        this.f_monitoringMode = monitoringMode;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.f_requestedParameters;
    }

    public void setRequestedParameters(MonitoringParameters monitoringParameters) {
        this.f_requestedParameters = monitoringParameters;
    }

    @Override
    public MonitoredItemCreateRequest clone() {
        MonitoredItemCreateRequest monitoredItemCreateRequest = (MonitoredItemCreateRequest)super.clone();
        monitoredItemCreateRequest.f_itemToMonitor = StructureUtils.clone(this.f_itemToMonitor);
        monitoredItemCreateRequest.f_monitoringMode = StructureUtils.clone(this.f_monitoringMode);
        monitoredItemCreateRequest.f_requestedParameters = StructureUtils.clone(this.f_requestedParameters);
        return monitoredItemCreateRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredItemCreateRequest monitoredItemCreateRequest = (MonitoredItemCreateRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getItemToMonitor(), monitoredItemCreateRequest.getItemToMonitor())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMonitoringMode(), monitoredItemCreateRequest.getMonitoringMode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRequestedParameters(), monitoredItemCreateRequest.getRequestedParameters());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getItemToMonitor(), this.getMonitoringMode(), this.getRequestedParameters());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_itemToMonitor = null;
        this.f_monitoringMode = null;
        this.f_requestedParameters = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.ItemToMonitor, this.getItemToMonitor());
        linkedHashMap.put(Fields.MonitoringMode, this.getMonitoringMode());
        linkedHashMap.put(Fields.RequestedParameters, this.getRequestedParameters());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ItemToMonitor.equals(fieldSpecification)) {
            return this.getItemToMonitor();
        }
        if (Fields.MonitoringMode.equals(fieldSpecification)) {
            return this.getMonitoringMode();
        }
        if (Fields.RequestedParameters.equals(fieldSpecification)) {
            return this.getRequestedParameters();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ItemToMonitor.equals(fieldSpecification)) {
            this.setItemToMonitor((ReadValueId)object);
            return;
        }
        if (Fields.MonitoringMode.equals(fieldSpecification)) {
            this.setMonitoringMode((MonitoringMode)object);
            return;
        }
        if (Fields.RequestedParameters.equals(fieldSpecification)) {
            this.setRequestedParameters((MonitoringParameters)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MonitoredItemCreateRequest.builder();
        builder.setItemToMonitor(StructureUtils.clone(this.getItemToMonitor()));
        builder.setMonitoringMode(StructureUtils.clone(this.getMonitoringMode()));
        builder.setRequestedParameters(StructureUtils.clone(this.getRequestedParameters()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.ItemToMonitor);
        builder.addField(Fields.MonitoringMode);
        builder.addField(Fields.RequestedParameters);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("MonitoredItemCreateRequest");
        builder.setJavaClass(MonitoredItemCreateRequest.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ReadValueId f_itemToMonitor;
        private MonitoringMode f_monitoringMode;
        private MonitoringParameters f_requestedParameters;

        protected Builder() {
        }

        public ReadValueId getItemToMonitor() {
            return this.f_itemToMonitor;
        }

        public Builder setItemToMonitor(ReadValueId readValueId) {
            this.f_itemToMonitor = readValueId;
            return this;
        }

        public MonitoringMode getMonitoringMode() {
            return this.f_monitoringMode;
        }

        public Builder setMonitoringMode(MonitoringMode monitoringMode) {
            this.f_monitoringMode = monitoringMode;
            return this;
        }

        public MonitoringParameters getRequestedParameters() {
            return this.f_requestedParameters;
        }

        public Builder setRequestedParameters(MonitoringParameters monitoringParameters) {
            this.f_requestedParameters = monitoringParameters;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getItemToMonitor(), builder.getItemToMonitor())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getMonitoringMode(), builder.getMonitoringMode())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getRequestedParameters(), builder.getRequestedParameters());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getItemToMonitor(), this.getMonitoringMode(), this.getRequestedParameters());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.ItemToMonitor.equals(fieldSpecification)) {
                return this.getItemToMonitor();
            }
            if (Fields.MonitoringMode.equals(fieldSpecification)) {
                return this.getMonitoringMode();
            }
            if (Fields.RequestedParameters.equals(fieldSpecification)) {
                return this.getRequestedParameters();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ItemToMonitor.equals(fieldSpecification)) {
                this.setItemToMonitor((ReadValueId)object);
                return this;
            }
            if (Fields.MonitoringMode.equals(fieldSpecification)) {
                this.setMonitoringMode((MonitoringMode)object);
                return this;
            }
            if (Fields.RequestedParameters.equals(fieldSpecification)) {
                this.setRequestedParameters((MonitoringParameters)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_itemToMonitor = null;
            this.f_monitoringMode = null;
            this.f_requestedParameters = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public MonitoredItemCreateRequest build() {
            return new MonitoredItemCreateRequest(this.f_itemToMonitor, this.f_monitoringMode, this.f_requestedParameters);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        ItemToMonitor("ItemToMonitor", ReadValueId.class, false, UaIds.ReadValueId, -1, null, false),
        MonitoringMode("MonitoringMode", MonitoringMode.class, false, UaIds.MonitoringMode, -1, null, false),
        RequestedParameters("RequestedParameters", MonitoringParameters.class, false, UaIds.MonitoringParameters, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

