/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DiscoveryConfiguration;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12891")
public class MdnsDiscoveryConfiguration
extends DiscoveryConfiguration {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MdnsDiscoveryConfiguration_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MdnsDiscoveryConfiguration_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MdnsDiscoveryConfiguration_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MdnsDiscoveryConfiguration;
    public static final StructureSpecification SPECIFICATION;
    private String f_mdnsServerName;
    private String[] f_serverCapabilities;

    public MdnsDiscoveryConfiguration() {
    }

    public MdnsDiscoveryConfiguration(String string, String[] stringArray) {
        this.f_mdnsServerName = string;
        this.f_serverCapabilities = stringArray;
    }

    public String getMdnsServerName() {
        return this.f_mdnsServerName;
    }

    public void setMdnsServerName(String string) {
        this.f_mdnsServerName = string;
    }

    public String[] getServerCapabilities() {
        return this.f_serverCapabilities;
    }

    public void setServerCapabilities(String[] stringArray) {
        this.f_serverCapabilities = stringArray;
    }

    @Override
    public MdnsDiscoveryConfiguration clone() {
        MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = (MdnsDiscoveryConfiguration)super.clone();
        mdnsDiscoveryConfiguration.f_mdnsServerName = StructureUtils.clone(this.f_mdnsServerName);
        mdnsDiscoveryConfiguration.f_serverCapabilities = StructureUtils.clone(this.f_serverCapabilities);
        return mdnsDiscoveryConfiguration;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = (MdnsDiscoveryConfiguration)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMdnsServerName(), mdnsDiscoveryConfiguration.getMdnsServerName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getServerCapabilities(), mdnsDiscoveryConfiguration.getServerCapabilities());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getMdnsServerName(), this.getServerCapabilities());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_mdnsServerName = null;
        this.f_serverCapabilities = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.MdnsServerName, this.getMdnsServerName());
        linkedHashMap.put(Fields.ServerCapabilities, this.getServerCapabilities());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.MdnsServerName.equals(fieldSpecification)) {
            return this.getMdnsServerName();
        }
        if (Fields.ServerCapabilities.equals(fieldSpecification)) {
            return this.getServerCapabilities();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.MdnsServerName.equals(fieldSpecification)) {
            this.setMdnsServerName((String)object);
            return;
        }
        if (Fields.ServerCapabilities.equals(fieldSpecification)) {
            this.setServerCapabilities((String[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MdnsDiscoveryConfiguration.builder();
        builder.setMdnsServerName(StructureUtils.clone(this.getMdnsServerName()));
        builder.setServerCapabilities(StructureUtils.clone(this.getServerCapabilities()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.MdnsServerName);
        builder.addField(Fields.ServerCapabilities);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DiscoveryConfiguration);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("MdnsDiscoveryConfiguration");
        builder.setJavaClass(MdnsDiscoveryConfiguration.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DiscoveryConfiguration.Builder {
        private String f_mdnsServerName;
        private String[] f_serverCapabilities;

        protected Builder() {
        }

        public String getMdnsServerName() {
            return this.f_mdnsServerName;
        }

        public Builder setMdnsServerName(String string) {
            this.f_mdnsServerName = string;
            return this;
        }

        public String[] getServerCapabilities() {
            return this.f_serverCapabilities;
        }

        public Builder setServerCapabilities(String[] stringArray) {
            this.f_serverCapabilities = stringArray;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getMdnsServerName(), builder.getMdnsServerName())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getServerCapabilities(), builder.getServerCapabilities());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getMdnsServerName(), this.getServerCapabilities());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.MdnsServerName.equals(fieldSpecification)) {
                return this.getMdnsServerName();
            }
            if (Fields.ServerCapabilities.equals(fieldSpecification)) {
                return this.getServerCapabilities();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.MdnsServerName.equals(fieldSpecification)) {
                this.setMdnsServerName((String)object);
                return this;
            }
            if (Fields.ServerCapabilities.equals(fieldSpecification)) {
                this.setServerCapabilities((String[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_mdnsServerName = null;
            this.f_serverCapabilities = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public MdnsDiscoveryConfiguration build() {
            return new MdnsDiscoveryConfiguration(this.f_mdnsServerName, this.f_serverCapabilities);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        MdnsServerName("MdnsServerName", String.class, false, UaIds.String, -1, null, false),
        ServerCapabilities("ServerCapabilities", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

