/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14533")
public class KeyValuePair
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.KeyValuePair_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.KeyValuePair_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.KeyValuePair_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.KeyValuePair;
    public static final StructureSpecification SPECIFICATION;
    private QualifiedName f_key;
    private Object f_value;

    public KeyValuePair() {
    }

    public KeyValuePair(QualifiedName qualifiedName, Object object) {
        this.f_key = qualifiedName;
        this.f_value = object;
    }

    public QualifiedName getKey() {
        return this.f_key;
    }

    public void setKey(QualifiedName qualifiedName) {
        this.f_key = qualifiedName;
    }

    public Object getValue() {
        return this.f_value;
    }

    public void setValue(Object object) {
        this.f_value = object;
    }

    @Override
    public KeyValuePair clone() {
        KeyValuePair keyValuePair = (KeyValuePair)super.clone();
        keyValuePair.f_key = StructureUtils.clone(this.f_key);
        keyValuePair.f_value = StructureUtils.clone(this.f_value);
        return keyValuePair;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyValuePair keyValuePair = (KeyValuePair)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getKey(), keyValuePair.getKey())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), keyValuePair.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getKey(), this.getValue());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_key = null;
        this.f_value = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Key, this.getKey());
        linkedHashMap.put(Fields.Value, this.getValue());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Key.equals(fieldSpecification)) {
            return this.getKey();
        }
        if (Fields.Value.equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Key.equals(fieldSpecification)) {
            this.setKey((QualifiedName)object);
            return;
        }
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue(object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = KeyValuePair.builder();
        builder.setKey(StructureUtils.clone(this.getKey()));
        builder.setValue(StructureUtils.clone(this.getValue()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Key);
        builder.addField(Fields.Value);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("KeyValuePair");
        builder.setJavaClass(KeyValuePair.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private QualifiedName f_key;
        private Object f_value;

        protected Builder() {
        }

        public QualifiedName getKey() {
            return this.f_key;
        }

        public Builder setKey(QualifiedName qualifiedName) {
            this.f_key = qualifiedName;
            return this;
        }

        public Object getValue() {
            return this.f_value;
        }

        public Builder setValue(Object object) {
            this.f_value = object;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getKey(), builder.getKey())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getValue(), builder.getValue());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getKey(), this.getValue());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Key.equals(fieldSpecification)) {
                return this.getKey();
            }
            if (Fields.Value.equals(fieldSpecification)) {
                return this.getValue();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Key.equals(fieldSpecification)) {
                this.setKey((QualifiedName)object);
                return this;
            }
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue(object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_key = null;
            this.f_value = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public KeyValuePair build() {
            return new KeyValuePair(this.f_key, this.f_value);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Key("Key", QualifiedName.class, false, UaIds.QualifiedName, -1, null, false),
        Value("Value", Object.class, false, UaIds.BaseDataType, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

