/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=938")
public class IssuedIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.IssuedIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.IssuedIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.IssuedIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.IssuedIdentityToken;
    public static final StructureSpecification SPECIFICATION;
    private ByteString f_tokenData;
    private String f_encryptionAlgorithm;

    public IssuedIdentityToken() {
    }

    public IssuedIdentityToken(ByteString byteString, String string) {
        this.f_tokenData = byteString;
        this.f_encryptionAlgorithm = string;
    }

    public IssuedIdentityToken(String string, ByteString byteString, String string2) {
        super(string);
        this.f_tokenData = byteString;
        this.f_encryptionAlgorithm = string2;
    }

    public ByteString getTokenData() {
        return this.f_tokenData;
    }

    public void setTokenData(ByteString byteString) {
        this.f_tokenData = byteString;
    }

    public String getEncryptionAlgorithm() {
        return this.f_encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.f_encryptionAlgorithm = string;
    }

    @Override
    public IssuedIdentityToken clone() {
        IssuedIdentityToken issuedIdentityToken = (IssuedIdentityToken)super.clone();
        issuedIdentityToken.f_tokenData = StructureUtils.clone(this.f_tokenData);
        issuedIdentityToken.f_encryptionAlgorithm = StructureUtils.clone(this.f_encryptionAlgorithm);
        return issuedIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IssuedIdentityToken issuedIdentityToken = (IssuedIdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), issuedIdentityToken.getPolicyId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTokenData(), issuedIdentityToken.getTokenData())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), issuedIdentityToken.getEncryptionAlgorithm());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getTokenData(), this.getEncryptionAlgorithm());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_tokenData = null;
        this.f_encryptionAlgorithm = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.PolicyId, this.getPolicyId());
        linkedHashMap.put(Fields.TokenData, this.getTokenData());
        linkedHashMap.put(Fields.EncryptionAlgorithm, this.getEncryptionAlgorithm());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.TokenData.equals(fieldSpecification)) {
            return this.getTokenData();
        }
        if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
            return this.getEncryptionAlgorithm();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.TokenData.equals(fieldSpecification)) {
            this.setTokenData((ByteString)object);
            return;
        }
        if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
            this.setEncryptionAlgorithm((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = IssuedIdentityToken.builder();
        builder.setPolicyId(StructureUtils.clone(this.getPolicyId()));
        builder.setTokenData(StructureUtils.clone(this.getTokenData()));
        builder.setEncryptionAlgorithm(StructureUtils.clone(this.getEncryptionAlgorithm()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId);
        builder.addField(Fields.TokenData);
        builder.addField(Fields.EncryptionAlgorithm);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.UserIdentityToken);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("IssuedIdentityToken");
        builder.setJavaClass(IssuedIdentityToken.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String f_policyId;
        private ByteString f_tokenData;
        private String f_encryptionAlgorithm;

        protected Builder() {
        }

        @Override
        public String getPolicyId() {
            return this.f_policyId;
        }

        @Override
        public Builder setPolicyId(String string) {
            this.f_policyId = string;
            return this;
        }

        public ByteString getTokenData() {
            return this.f_tokenData;
        }

        public Builder setTokenData(ByteString byteString) {
            this.f_tokenData = byteString;
            return this;
        }

        public String getEncryptionAlgorithm() {
            return this.f_encryptionAlgorithm;
        }

        public Builder setEncryptionAlgorithm(String string) {
            this.f_encryptionAlgorithm = string;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), builder.getPolicyId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTokenData(), builder.getTokenData())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), builder.getEncryptionAlgorithm());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getPolicyId(), this.getTokenData(), this.getEncryptionAlgorithm());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                return this.getPolicyId();
            }
            if (Fields.TokenData.equals(fieldSpecification)) {
                return this.getTokenData();
            }
            if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
                return this.getEncryptionAlgorithm();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.TokenData.equals(fieldSpecification)) {
                this.setTokenData((ByteString)object);
                return this;
            }
            if (Fields.EncryptionAlgorithm.equals(fieldSpecification)) {
                this.setEncryptionAlgorithm((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_tokenData = null;
            this.f_encryptionAlgorithm = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public IssuedIdentityToken build() {
            return new IssuedIdentityToken(this.f_policyId, this.f_tokenData, this.f_encryptionAlgorithm);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        PolicyId("PolicyId", String.class, false, UaIds.String, -1, null, false),
        TokenData("TokenData", ByteString.class, false, UaIds.ByteString, -1, null, false),
        EncryptionAlgorithm("EncryptionAlgorithm", String.class, false, UaIds.String, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

