/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24214")
public enum InterfaceOperStatus implements Enumeration
{
    Up(0),
    Down(1),
    Testing(2),
    Unknown(3),
    Dormant(4),
    NotPresent(5),
    LowerLayerDown(6);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<InterfaceOperStatus> NONE;
    public static final EnumSet<InterfaceOperStatus> ALL;
    private static final Map<Integer, InterfaceOperStatus> map;
    private final int value;

    private InterfaceOperStatus(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static InterfaceOperStatus valueOf(int n2) {
        return map.get(n2);
    }

    public static InterfaceOperStatus valueOf(Integer n2) {
        return n2 == null ? null : InterfaceOperStatus.valueOf((int)n2);
    }

    public static InterfaceOperStatus valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : InterfaceOperStatus.valueOf(unsignedInteger.intValue());
    }

    public static InterfaceOperStatus[] valueOf(int[] nArray) {
        InterfaceOperStatus[] interfaceOperStatusArray = new InterfaceOperStatus[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            interfaceOperStatusArray[i2] = InterfaceOperStatus.valueOf(nArray[i2]);
        }
        return interfaceOperStatusArray;
    }

    public static InterfaceOperStatus[] valueOf(Integer[] integerArray) {
        InterfaceOperStatus[] interfaceOperStatusArray = new InterfaceOperStatus[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            interfaceOperStatusArray[i2] = InterfaceOperStatus.valueOf(integerArray[i2]);
        }
        return interfaceOperStatusArray;
    }

    public static InterfaceOperStatus[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        InterfaceOperStatus[] interfaceOperStatusArray = new InterfaceOperStatus[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            interfaceOperStatusArray[i2] = InterfaceOperStatus.valueOf(unsignedIntegerArray[i2]);
        }
        return interfaceOperStatusArray;
    }

    public static UnsignedInteger getMask(InterfaceOperStatus ... interfaceOperStatusArray) {
        int n2 = 0;
        for (InterfaceOperStatus interfaceOperStatus : interfaceOperStatusArray) {
            n2 |= interfaceOperStatus.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<InterfaceOperStatus> collection) {
        int n2 = 0;
        for (InterfaceOperStatus interfaceOperStatus : collection) {
            n2 |= interfaceOperStatus.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<InterfaceOperStatus> getSet(UnsignedInteger unsignedInteger) {
        return InterfaceOperStatus.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<InterfaceOperStatus> getSet(int n2) {
        ArrayList<InterfaceOperStatus> arrayList = new ArrayList<InterfaceOperStatus>();
        for (InterfaceOperStatus interfaceOperStatus : InterfaceOperStatus.values()) {
            if ((n2 & interfaceOperStatus.value) != interfaceOperStatus.value) continue;
            arrayList.add(interfaceOperStatus);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = InterfaceOperStatus.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(InterfaceOperStatus.class);
        ALL = EnumSet.allOf(InterfaceOperStatus.class);
        map = new HashMap<Integer, InterfaceOperStatus>();
        for (InterfaceOperStatus interfaceOperStatus : InterfaceOperStatus.values()) {
            map.put(interfaceOperStatus.value, interfaceOperStatus);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("InterfaceOperStatus");
        builder.setJavaClass(InterfaceOperStatus.class);
        builder.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24214")));
        builder.addMapping(0, "Up");
        builder.addMapping(1, "Down");
        builder.addMapping(2, "Testing");
        builder.addMapping(3, "Unknown");
        builder.addMapping(4, "Dormant");
        builder.addMapping(5, "NotPresent");
        builder.addMapping(6, "LowerLayerDown");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return InterfaceOperStatus.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private InterfaceOperStatus value;

        private Builder() {
        }

        @Override
        public InterfaceOperStatus build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = InterfaceOperStatus.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum InterfaceOperStatus int value: " + n2);
            }
            return this;
        }
    }
}

