/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=256")
public enum IdType implements Enumeration
{
    Numeric(0),
    String(1),
    Guid(2),
    Opaque(3);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<IdType> NONE;
    public static final EnumSet<IdType> ALL;
    private static final Map<Integer, IdType> map;
    private final int value;

    private IdType(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static IdType valueOf(int n2) {
        return map.get(n2);
    }

    public static IdType valueOf(Integer n2) {
        return n2 == null ? null : IdType.valueOf((int)n2);
    }

    public static IdType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : IdType.valueOf(unsignedInteger.intValue());
    }

    public static IdType[] valueOf(int[] nArray) {
        IdType[] idTypeArray = new IdType[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            idTypeArray[i2] = IdType.valueOf(nArray[i2]);
        }
        return idTypeArray;
    }

    public static IdType[] valueOf(Integer[] integerArray) {
        IdType[] idTypeArray = new IdType[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            idTypeArray[i2] = IdType.valueOf(integerArray[i2]);
        }
        return idTypeArray;
    }

    public static IdType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        IdType[] idTypeArray = new IdType[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            idTypeArray[i2] = IdType.valueOf(unsignedIntegerArray[i2]);
        }
        return idTypeArray;
    }

    public static UnsignedInteger getMask(IdType ... idTypeArray) {
        int n2 = 0;
        for (IdType idType : idTypeArray) {
            n2 |= idType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<IdType> collection) {
        int n2 = 0;
        for (IdType idType : collection) {
            n2 |= idType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<IdType> getSet(UnsignedInteger unsignedInteger) {
        return IdType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<IdType> getSet(int n2) {
        ArrayList<IdType> arrayList = new ArrayList<IdType>();
        for (IdType idType : IdType.values()) {
            if ((n2 & idType.value) != idType.value) continue;
            arrayList.add(idType);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = IdType.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(IdType.class);
        ALL = EnumSet.allOf(IdType.class);
        map = new HashMap<Integer, IdType>();
        for (IdType idType : IdType.values()) {
            map.put(idType.value, idType);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("IdType");
        builder.setJavaClass(IdType.class);
        builder.addMapping(0, "Numeric");
        builder.addMapping(1, "String");
        builder.addMapping(2, "Guid");
        builder.addMapping(3, "Opaque");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return IdType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private IdType value;

        private Builder() {
        }

        @Override
        public IdType build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = IdType.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum IdType int value: " + n2);
            }
            return this;
        }
    }
}

