/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=662")
public class HistoryReadRequest
extends AbstractStructure
implements ServiceRequest<HistoryReadResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryReadRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryReadRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryReadRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryReadRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader f_requestHeader;
    private ExtensionObject f_historyReadDetails;
    private TimestampsToReturn f_timestampsToReturn;
    private Boolean f_releaseContinuationPoints;
    private HistoryReadValueId[] f_nodesToRead;

    public HistoryReadRequest() {
    }

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject extensionObject, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId[] historyReadValueIdArray) {
        this.f_requestHeader = requestHeader;
        this.f_historyReadDetails = extensionObject;
        this.f_timestampsToReturn = timestampsToReturn;
        this.f_releaseContinuationPoints = bl;
        this.f_nodesToRead = historyReadValueIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.f_requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.f_requestHeader = requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.f_historyReadDetails;
    }

    public void setHistoryReadDetails(ExtensionObject extensionObject) {
        this.f_historyReadDetails = extensionObject;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.f_timestampsToReturn;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.f_timestampsToReturn = timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.f_releaseContinuationPoints;
    }

    public void setReleaseContinuationPoints(Boolean bl) {
        this.f_releaseContinuationPoints = bl;
    }

    public HistoryReadValueId[] getNodesToRead() {
        return this.f_nodesToRead;
    }

    public void setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
        this.f_nodesToRead = historyReadValueIdArray;
    }

    @Override
    public HistoryReadRequest clone() {
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)super.clone();
        historyReadRequest.f_requestHeader = StructureUtils.clone(this.f_requestHeader);
        historyReadRequest.f_historyReadDetails = StructureUtils.clone(this.f_historyReadDetails);
        historyReadRequest.f_timestampsToReturn = StructureUtils.clone(this.f_timestampsToReturn);
        historyReadRequest.f_releaseContinuationPoints = StructureUtils.clone(this.f_releaseContinuationPoints);
        historyReadRequest.f_nodesToRead = StructureUtils.clone(this.f_nodesToRead);
        return historyReadRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), historyReadRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getHistoryReadDetails(), historyReadRequest.getHistoryReadDetails())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestampsToReturn(), historyReadRequest.getTimestampsToReturn())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReleaseContinuationPoints(), historyReadRequest.getReleaseContinuationPoints())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToRead(), historyReadRequest.getNodesToRead());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNodesToRead());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_requestHeader = null;
        this.f_historyReadDetails = null;
        this.f_timestampsToReturn = null;
        this.f_releaseContinuationPoints = null;
        this.f_nodesToRead = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.RequestHeader, this.getRequestHeader());
        linkedHashMap.put(Fields.HistoryReadDetails, this.getHistoryReadDetails());
        linkedHashMap.put(Fields.TimestampsToReturn, this.getTimestampsToReturn());
        linkedHashMap.put(Fields.ReleaseContinuationPoints, this.getReleaseContinuationPoints());
        linkedHashMap.put(Fields.NodesToRead, this.getNodesToRead());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.HistoryReadDetails.equals(fieldSpecification)) {
            return this.getHistoryReadDetails();
        }
        if (Fields.TimestampsToReturn.equals(fieldSpecification)) {
            return this.getTimestampsToReturn();
        }
        if (Fields.ReleaseContinuationPoints.equals(fieldSpecification)) {
            return this.getReleaseContinuationPoints();
        }
        if (Fields.NodesToRead.equals(fieldSpecification)) {
            return this.getNodesToRead();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.HistoryReadDetails.equals(fieldSpecification)) {
            this.setHistoryReadDetails((ExtensionObject)object);
            return;
        }
        if (Fields.TimestampsToReturn.equals(fieldSpecification)) {
            this.setTimestampsToReturn((TimestampsToReturn)object);
            return;
        }
        if (Fields.ReleaseContinuationPoints.equals(fieldSpecification)) {
            this.setReleaseContinuationPoints((Boolean)object);
            return;
        }
        if (Fields.NodesToRead.equals(fieldSpecification)) {
            this.setNodesToRead((HistoryReadValueId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryReadRequest.builder();
        builder.setRequestHeader(StructureUtils.clone(this.getRequestHeader()));
        builder.setHistoryReadDetails(StructureUtils.clone(this.getHistoryReadDetails()));
        builder.setTimestampsToReturn(StructureUtils.clone(this.getTimestampsToReturn()));
        builder.setReleaseContinuationPoints(StructureUtils.clone(this.getReleaseContinuationPoints()));
        builder.setNodesToRead(StructureUtils.clone(this.getNodesToRead()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader);
        builder.addField(Fields.HistoryReadDetails);
        builder.addField(Fields.TimestampsToReturn);
        builder.addField(Fields.ReleaseContinuationPoints);
        builder.addField(Fields.NodesToRead);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("HistoryReadRequest");
        builder.setJavaClass(HistoryReadRequest.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader f_requestHeader;
        private ExtensionObject f_historyReadDetails;
        private TimestampsToReturn f_timestampsToReturn;
        private Boolean f_releaseContinuationPoints;
        private HistoryReadValueId[] f_nodesToRead;

        protected Builder() {
        }

        public RequestHeader getRequestHeader() {
            return this.f_requestHeader;
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.f_requestHeader = requestHeader;
            return this;
        }

        public ExtensionObject getHistoryReadDetails() {
            return this.f_historyReadDetails;
        }

        public Builder setHistoryReadDetails(ExtensionObject extensionObject) {
            this.f_historyReadDetails = extensionObject;
            return this;
        }

        public TimestampsToReturn getTimestampsToReturn() {
            return this.f_timestampsToReturn;
        }

        public Builder setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.f_timestampsToReturn = timestampsToReturn;
            return this;
        }

        public Boolean getReleaseContinuationPoints() {
            return this.f_releaseContinuationPoints;
        }

        public Builder setReleaseContinuationPoints(Boolean bl) {
            this.f_releaseContinuationPoints = bl;
            return this;
        }

        public HistoryReadValueId[] getNodesToRead() {
            return this.f_nodesToRead;
        }

        public Builder setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
            this.f_nodesToRead = historyReadValueIdArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), builder.getRequestHeader())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getHistoryReadDetails(), builder.getHistoryReadDetails())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTimestampsToReturn(), builder.getTimestampsToReturn())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getReleaseContinuationPoints(), builder.getReleaseContinuationPoints())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getNodesToRead(), builder.getNodesToRead());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNodesToRead());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                return this.getRequestHeader();
            }
            if (Fields.HistoryReadDetails.equals(fieldSpecification)) {
                return this.getHistoryReadDetails();
            }
            if (Fields.TimestampsToReturn.equals(fieldSpecification)) {
                return this.getTimestampsToReturn();
            }
            if (Fields.ReleaseContinuationPoints.equals(fieldSpecification)) {
                return this.getReleaseContinuationPoints();
            }
            if (Fields.NodesToRead.equals(fieldSpecification)) {
                return this.getNodesToRead();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.HistoryReadDetails.equals(fieldSpecification)) {
                this.setHistoryReadDetails((ExtensionObject)object);
                return this;
            }
            if (Fields.TimestampsToReturn.equals(fieldSpecification)) {
                this.setTimestampsToReturn((TimestampsToReturn)object);
                return this;
            }
            if (Fields.ReleaseContinuationPoints.equals(fieldSpecification)) {
                this.setReleaseContinuationPoints((Boolean)object);
                return this;
            }
            if (Fields.NodesToRead.equals(fieldSpecification)) {
                this.setNodesToRead((HistoryReadValueId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_requestHeader = null;
            this.f_historyReadDetails = null;
            this.f_timestampsToReturn = null;
            this.f_releaseContinuationPoints = null;
            this.f_nodesToRead = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public HistoryReadRequest build() {
            return new HistoryReadRequest(this.f_requestHeader, this.f_historyReadDetails, this.f_timestampsToReturn, this.f_releaseContinuationPoints, this.f_nodesToRead);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaIds.RequestHeader, -1, null, false),
        HistoryReadDetails("HistoryReadDetails", ExtensionObject.class, false, UaIds.Structure, -1, null, false),
        TimestampsToReturn("TimestampsToReturn", TimestampsToReturn.class, false, UaIds.TimestampsToReturn, -1, null, false),
        ReleaseContinuationPoints("ReleaseContinuationPoints", Boolean.class, false, UaIds.Boolean, -1, null, false),
        NodesToRead("NodesToRead", HistoryReadValueId[].class, false, UaIds.HistoryReadValueId, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

