/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryEvent;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.ModificationInfo;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32824")
public class HistoryModifiedEvent
extends HistoryEvent {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryModifiedEvent_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryModifiedEvent_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryModifiedEvent_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryModifiedEvent;
    public static final StructureSpecification SPECIFICATION;
    private ModificationInfo[] f_modificationInfos;

    public HistoryModifiedEvent() {
    }

    public HistoryModifiedEvent(ModificationInfo[] modificationInfoArray) {
        this.f_modificationInfos = modificationInfoArray;
    }

    public HistoryModifiedEvent(HistoryEventFieldList[] historyEventFieldListArray, ModificationInfo[] modificationInfoArray) {
        super(historyEventFieldListArray);
        this.f_modificationInfos = modificationInfoArray;
    }

    public ModificationInfo[] getModificationInfos() {
        return this.f_modificationInfos;
    }

    public void setModificationInfos(ModificationInfo[] modificationInfoArray) {
        this.f_modificationInfos = modificationInfoArray;
    }

    @Override
    public HistoryModifiedEvent clone() {
        HistoryModifiedEvent historyModifiedEvent = (HistoryModifiedEvent)super.clone();
        historyModifiedEvent.f_modificationInfos = StructureUtils.clone(this.f_modificationInfos);
        return historyModifiedEvent;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryModifiedEvent historyModifiedEvent = (HistoryModifiedEvent)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEvents(), historyModifiedEvent.getEvents())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getModificationInfos(), historyModifiedEvent.getModificationInfos());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getEvents(), this.getModificationInfos());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_modificationInfos = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, AbstractStructure[]> linkedHashMap = new LinkedHashMap<Fields, AbstractStructure[]>();
        linkedHashMap.put(Fields.Events, this.getEvents());
        linkedHashMap.put(Fields.ModificationInfos, this.getModificationInfos());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Events.equals(fieldSpecification)) {
            return this.getEvents();
        }
        if (Fields.ModificationInfos.equals(fieldSpecification)) {
            return this.getModificationInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Events.equals(fieldSpecification)) {
            this.setEvents((HistoryEventFieldList[])object);
            return;
        }
        if (Fields.ModificationInfos.equals(fieldSpecification)) {
            this.setModificationInfos((ModificationInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryModifiedEvent.builder();
        builder.setEvents(StructureUtils.clone(this.getEvents()));
        builder.setModificationInfos(StructureUtils.clone(this.getModificationInfos()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Events);
        builder.addField(Fields.ModificationInfos);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.HistoryEvent);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("HistoryModifiedEvent");
        builder.setJavaClass(HistoryModifiedEvent.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryEvent.Builder {
        private HistoryEventFieldList[] f_events;
        private ModificationInfo[] f_modificationInfos;

        protected Builder() {
        }

        @Override
        public HistoryEventFieldList[] getEvents() {
            return this.f_events;
        }

        @Override
        public Builder setEvents(HistoryEventFieldList[] historyEventFieldListArray) {
            this.f_events = historyEventFieldListArray;
            return this;
        }

        public ModificationInfo[] getModificationInfos() {
            return this.f_modificationInfos;
        }

        public Builder setModificationInfos(ModificationInfo[] modificationInfoArray) {
            this.f_modificationInfos = modificationInfoArray;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getEvents(), builder.getEvents())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getModificationInfos(), builder.getModificationInfos());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getEvents(), this.getModificationInfos());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Events.equals(fieldSpecification)) {
                return this.getEvents();
            }
            if (Fields.ModificationInfos.equals(fieldSpecification)) {
                return this.getModificationInfos();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Events.equals(fieldSpecification)) {
                this.setEvents((HistoryEventFieldList[])object);
                return this;
            }
            if (Fields.ModificationInfos.equals(fieldSpecification)) {
                this.setModificationInfos((ModificationInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_modificationInfos = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public HistoryModifiedEvent build() {
            return new HistoryModifiedEvent(this.f_events, this.f_modificationInfos);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Events("Events", HistoryEventFieldList[].class, false, UaIds.HistoryEventFieldList, 1, UaArrayDimensions.valueOf(0L), false),
        ModificationInfos("ModificationInfos", ModificationInfo[].class, false, UaIds.ModificationInfo, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

