/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=659")
public class HistoryEvent
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryEvent_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryEvent_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryEvent_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryEvent;
    public static final StructureSpecification SPECIFICATION;
    private HistoryEventFieldList[] f_events;

    public HistoryEvent() {
    }

    public HistoryEvent(HistoryEventFieldList[] historyEventFieldListArray) {
        this.f_events = historyEventFieldListArray;
    }

    public HistoryEventFieldList[] getEvents() {
        return this.f_events;
    }

    public void setEvents(HistoryEventFieldList[] historyEventFieldListArray) {
        this.f_events = historyEventFieldListArray;
    }

    @Override
    public HistoryEvent clone() {
        HistoryEvent historyEvent = (HistoryEvent)super.clone();
        historyEvent.f_events = StructureUtils.clone(this.f_events);
        return historyEvent;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryEvent historyEvent = (HistoryEvent)object;
        return StructureUtils.scalarOrArrayEquals(this.getEvents(), historyEvent.getEvents());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEvents());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_events = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, HistoryEventFieldList[]> linkedHashMap = new LinkedHashMap<Fields, HistoryEventFieldList[]>();
        linkedHashMap.put(Fields.Events, this.getEvents());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Events.equals(fieldSpecification)) {
            return this.getEvents();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Events.equals(fieldSpecification)) {
            this.setEvents((HistoryEventFieldList[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryEvent.builder();
        builder.setEvents(StructureUtils.clone(this.getEvents()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Events);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("HistoryEvent");
        builder.setJavaClass(HistoryEvent.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private HistoryEventFieldList[] f_events;

        protected Builder() {
        }

        public HistoryEventFieldList[] getEvents() {
            return this.f_events;
        }

        public Builder setEvents(HistoryEventFieldList[] historyEventFieldListArray) {
            this.f_events = historyEventFieldListArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            return StructureUtils.scalarOrArrayEquals(this.getEvents(), builder.getEvents());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getEvents());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Events.equals(fieldSpecification)) {
                return this.getEvents();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Events.equals(fieldSpecification)) {
                this.setEvents((HistoryEventFieldList[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_events = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public HistoryEvent build() {
            return new HistoryEvent(this.f_events);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Events("Events", HistoryEventFieldList[].class, false, UaIds.HistoryEventFieldList, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

