/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=656")
public class HistoryData
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryData_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryData_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryData_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryData;
    public static final StructureSpecification SPECIFICATION;
    private DataValue[] f_dataValues;

    public HistoryData() {
    }

    public HistoryData(DataValue[] dataValueArray) {
        this.f_dataValues = dataValueArray;
    }

    public DataValue[] getDataValues() {
        return this.f_dataValues;
    }

    public void setDataValues(DataValue[] dataValueArray) {
        this.f_dataValues = dataValueArray;
    }

    @Override
    public HistoryData clone() {
        HistoryData historyData = (HistoryData)super.clone();
        historyData.f_dataValues = StructureUtils.clone(this.f_dataValues);
        return historyData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryData historyData = (HistoryData)object;
        return StructureUtils.scalarOrArrayEquals(this.getDataValues(), historyData.getDataValues());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getDataValues());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_dataValues = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, DataValue[]> linkedHashMap = new LinkedHashMap<Fields, DataValue[]>();
        linkedHashMap.put(Fields.DataValues, this.getDataValues());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataValues.equals(fieldSpecification)) {
            return this.getDataValues();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataValues.equals(fieldSpecification)) {
            this.setDataValues((DataValue[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryData.builder();
        builder.setDataValues(StructureUtils.clone(this.getDataValues()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.DataValues);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("HistoryData");
        builder.setJavaClass(HistoryData.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private DataValue[] f_dataValues;

        protected Builder() {
        }

        public DataValue[] getDataValues() {
            return this.f_dataValues;
        }

        public Builder setDataValues(DataValue[] dataValueArray) {
            this.f_dataValues = dataValueArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            return StructureUtils.scalarOrArrayEquals(this.getDataValues(), builder.getDataValues());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getDataValues());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.DataValues.equals(fieldSpecification)) {
                return this.getDataValues();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataValues.equals(fieldSpecification)) {
                this.setDataValues((DataValue[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_dataValues = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public HistoryData build() {
            return new HistoryData(this.f_dataValues);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        DataValues("DataValues", DataValue[].class, false, UaIds.DataValue, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

