/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17606")
public class GenericAttributeValue
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.GenericAttributeValue_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.GenericAttributeValue_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.GenericAttributeValue_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.GenericAttributeValue;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger f_attributeId;
    private Object f_value;

    public GenericAttributeValue() {
    }

    public GenericAttributeValue(UnsignedInteger unsignedInteger, Object object) {
        this.f_attributeId = unsignedInteger;
        this.f_value = object;
    }

    public UnsignedInteger getAttributeId() {
        return this.f_attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.f_attributeId = unsignedInteger;
    }

    public Object getValue() {
        return this.f_value;
    }

    public void setValue(Object object) {
        this.f_value = object;
    }

    @Override
    public GenericAttributeValue clone() {
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)super.clone();
        genericAttributeValue.f_attributeId = StructureUtils.clone(this.f_attributeId);
        genericAttributeValue.f_value = StructureUtils.clone(this.f_value);
        return genericAttributeValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), genericAttributeValue.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), genericAttributeValue.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getAttributeId(), this.getValue());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_attributeId = null;
        this.f_value = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.AttributeId, this.getAttributeId());
        linkedHashMap.put(Fields.Value, this.getValue());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.AttributeId.equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.Value.equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.AttributeId.equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue(object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = GenericAttributeValue.builder();
        builder.setAttributeId(StructureUtils.clone(this.getAttributeId()));
        builder.setValue(StructureUtils.clone(this.getValue()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.AttributeId);
        builder.addField(Fields.Value);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("GenericAttributeValue");
        builder.setJavaClass(GenericAttributeValue.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger f_attributeId;
        private Object f_value;

        protected Builder() {
        }

        public UnsignedInteger getAttributeId() {
            return this.f_attributeId;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.f_attributeId = unsignedInteger;
            return this;
        }

        public Object getValue() {
            return this.f_value;
        }

        public Builder setValue(Object object) {
            this.f_value = object;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), builder.getAttributeId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getValue(), builder.getValue());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getAttributeId(), this.getValue());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.AttributeId.equals(fieldSpecification)) {
                return this.getAttributeId();
            }
            if (Fields.Value.equals(fieldSpecification)) {
                return this.getValue();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.AttributeId.equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue(object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_attributeId = null;
            this.f_value = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public GenericAttributeValue build() {
            return new GenericAttributeValue(this.f_attributeId, this.f_value);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        AttributeId("AttributeId", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false),
        Value("Value", Object.class, false, UaIds.BaseDataType, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

