/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.DataSetFieldFlags;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14524")
public class FieldMetaData
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.FieldMetaData_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.FieldMetaData_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.FieldMetaData_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.FieldMetaData;
    public static final StructureSpecification SPECIFICATION;
    private String f_name;
    private LocalizedText f_description;
    private DataSetFieldFlags f_fieldFlags;
    private UnsignedByte f_builtInType;
    private NodeId f_dataType;
    private Integer f_valueRank;
    private UnsignedInteger[] f_arrayDimensions;
    private UnsignedInteger f_maxStringLength;
    private UUID f_dataSetFieldId;
    private KeyValuePair[] f_properties;

    public FieldMetaData() {
    }

    public FieldMetaData(String string, LocalizedText localizedText, DataSetFieldFlags dataSetFieldFlags, UnsignedByte unsignedByte, NodeId nodeId, Integer n2, UnsignedInteger[] unsignedIntegerArray, UnsignedInteger unsignedInteger, UUID uUID, KeyValuePair[] keyValuePairArray) {
        this.f_name = string;
        this.f_description = localizedText;
        this.f_fieldFlags = dataSetFieldFlags;
        this.f_builtInType = unsignedByte;
        this.f_dataType = nodeId;
        this.f_valueRank = n2;
        this.f_arrayDimensions = unsignedIntegerArray;
        this.f_maxStringLength = unsignedInteger;
        this.f_dataSetFieldId = uUID;
        this.f_properties = keyValuePairArray;
    }

    public String getName() {
        return this.f_name;
    }

    public void setName(String string) {
        this.f_name = string;
    }

    public LocalizedText getDescription() {
        return this.f_description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.f_description = localizedText;
    }

    public DataSetFieldFlags getFieldFlags() {
        return this.f_fieldFlags;
    }

    public void setFieldFlags(DataSetFieldFlags dataSetFieldFlags) {
        this.f_fieldFlags = dataSetFieldFlags;
    }

    public UnsignedByte getBuiltInType() {
        return this.f_builtInType;
    }

    public void setBuiltInType(UnsignedByte unsignedByte) {
        this.f_builtInType = unsignedByte;
    }

    public NodeId getDataType() {
        return this.f_dataType;
    }

    public void setDataType(NodeId nodeId) {
        this.f_dataType = nodeId;
    }

    public Integer getValueRank() {
        return this.f_valueRank;
    }

    public void setValueRank(Integer n2) {
        this.f_valueRank = n2;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.f_arrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.f_arrayDimensions = unsignedIntegerArray;
    }

    public UnsignedInteger getMaxStringLength() {
        return this.f_maxStringLength;
    }

    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        this.f_maxStringLength = unsignedInteger;
    }

    public UUID getDataSetFieldId() {
        return this.f_dataSetFieldId;
    }

    public void setDataSetFieldId(UUID uUID) {
        this.f_dataSetFieldId = uUID;
    }

    public KeyValuePair[] getProperties() {
        return this.f_properties;
    }

    public void setProperties(KeyValuePair[] keyValuePairArray) {
        this.f_properties = keyValuePairArray;
    }

    @Override
    public FieldMetaData clone() {
        FieldMetaData fieldMetaData = (FieldMetaData)super.clone();
        fieldMetaData.f_name = StructureUtils.clone(this.f_name);
        fieldMetaData.f_description = StructureUtils.clone(this.f_description);
        fieldMetaData.f_fieldFlags = StructureUtils.clone(this.f_fieldFlags);
        fieldMetaData.f_builtInType = StructureUtils.clone(this.f_builtInType);
        fieldMetaData.f_dataType = StructureUtils.clone(this.f_dataType);
        fieldMetaData.f_valueRank = StructureUtils.clone(this.f_valueRank);
        fieldMetaData.f_arrayDimensions = StructureUtils.clone(this.f_arrayDimensions);
        fieldMetaData.f_maxStringLength = StructureUtils.clone(this.f_maxStringLength);
        fieldMetaData.f_dataSetFieldId = StructureUtils.clone(this.f_dataSetFieldId);
        fieldMetaData.f_properties = StructureUtils.clone(this.f_properties);
        return fieldMetaData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldMetaData fieldMetaData = (FieldMetaData)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), fieldMetaData.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), fieldMetaData.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getFieldFlags(), fieldMetaData.getFieldFlags())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBuiltInType(), fieldMetaData.getBuiltInType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataType(), fieldMetaData.getDataType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getValueRank(), fieldMetaData.getValueRank())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getArrayDimensions(), fieldMetaData.getArrayDimensions())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxStringLength(), fieldMetaData.getMaxStringLength())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataSetFieldId(), fieldMetaData.getDataSetFieldId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getProperties(), fieldMetaData.getProperties());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getName(), this.getDescription(), this.getFieldFlags(), this.getBuiltInType(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getMaxStringLength(), this.getDataSetFieldId(), this.getProperties());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_name = null;
        this.f_description = null;
        this.f_fieldFlags = null;
        this.f_builtInType = null;
        this.f_dataType = null;
        this.f_valueRank = null;
        this.f_arrayDimensions = null;
        this.f_maxStringLength = null;
        this.f_dataSetFieldId = null;
        this.f_properties = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Name, this.getName());
        linkedHashMap.put(Fields.Description, this.getDescription());
        linkedHashMap.put(Fields.FieldFlags, this.getFieldFlags());
        linkedHashMap.put(Fields.BuiltInType, this.getBuiltInType());
        linkedHashMap.put(Fields.DataType, this.getDataType());
        linkedHashMap.put(Fields.ValueRank, this.getValueRank());
        linkedHashMap.put(Fields.ArrayDimensions, this.getArrayDimensions());
        linkedHashMap.put(Fields.MaxStringLength, this.getMaxStringLength());
        linkedHashMap.put(Fields.DataSetFieldId, this.getDataSetFieldId());
        linkedHashMap.put(Fields.Properties, this.getProperties());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.FieldFlags.equals(fieldSpecification)) {
            return this.getFieldFlags();
        }
        if (Fields.BuiltInType.equals(fieldSpecification)) {
            return this.getBuiltInType();
        }
        if (Fields.DataType.equals(fieldSpecification)) {
            return this.getDataType();
        }
        if (Fields.ValueRank.equals(fieldSpecification)) {
            return this.getValueRank();
        }
        if (Fields.ArrayDimensions.equals(fieldSpecification)) {
            return this.getArrayDimensions();
        }
        if (Fields.MaxStringLength.equals(fieldSpecification)) {
            return this.getMaxStringLength();
        }
        if (Fields.DataSetFieldId.equals(fieldSpecification)) {
            return this.getDataSetFieldId();
        }
        if (Fields.Properties.equals(fieldSpecification)) {
            return this.getProperties();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.FieldFlags.equals(fieldSpecification)) {
            this.setFieldFlags((DataSetFieldFlags)object);
            return;
        }
        if (Fields.BuiltInType.equals(fieldSpecification)) {
            this.setBuiltInType((UnsignedByte)object);
            return;
        }
        if (Fields.DataType.equals(fieldSpecification)) {
            this.setDataType((NodeId)object);
            return;
        }
        if (Fields.ValueRank.equals(fieldSpecification)) {
            this.setValueRank((Integer)object);
            return;
        }
        if (Fields.ArrayDimensions.equals(fieldSpecification)) {
            this.setArrayDimensions((UnsignedInteger[])object);
            return;
        }
        if (Fields.MaxStringLength.equals(fieldSpecification)) {
            this.setMaxStringLength((UnsignedInteger)object);
            return;
        }
        if (Fields.DataSetFieldId.equals(fieldSpecification)) {
            this.setDataSetFieldId((UUID)object);
            return;
        }
        if (Fields.Properties.equals(fieldSpecification)) {
            this.setProperties((KeyValuePair[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = FieldMetaData.builder();
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        builder.setFieldFlags(StructureUtils.clone(this.getFieldFlags()));
        builder.setBuiltInType(StructureUtils.clone(this.getBuiltInType()));
        builder.setDataType(StructureUtils.clone(this.getDataType()));
        builder.setValueRank(StructureUtils.clone(this.getValueRank()));
        builder.setArrayDimensions(StructureUtils.clone(this.getArrayDimensions()));
        builder.setMaxStringLength(StructureUtils.clone(this.getMaxStringLength()));
        builder.setDataSetFieldId(StructureUtils.clone(this.getDataSetFieldId()));
        builder.setProperties(StructureUtils.clone(this.getProperties()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Name);
        builder.addField(Fields.Description);
        builder.addField(Fields.FieldFlags);
        builder.addField(Fields.BuiltInType);
        builder.addField(Fields.DataType);
        builder.addField(Fields.ValueRank);
        builder.addField(Fields.ArrayDimensions);
        builder.addField(Fields.MaxStringLength);
        builder.addField(Fields.DataSetFieldId);
        builder.addField(Fields.Properties);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("FieldMetaData");
        builder.setJavaClass(FieldMetaData.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_name;
        private LocalizedText f_description;
        private DataSetFieldFlags f_fieldFlags;
        private UnsignedByte f_builtInType;
        private NodeId f_dataType;
        private Integer f_valueRank;
        private UnsignedInteger[] f_arrayDimensions;
        private UnsignedInteger f_maxStringLength;
        private UUID f_dataSetFieldId;
        private KeyValuePair[] f_properties;

        protected Builder() {
        }

        public String getName() {
            return this.f_name;
        }

        public Builder setName(String string) {
            this.f_name = string;
            return this;
        }

        public LocalizedText getDescription() {
            return this.f_description;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        public DataSetFieldFlags getFieldFlags() {
            return this.f_fieldFlags;
        }

        public Builder setFieldFlags(DataSetFieldFlags dataSetFieldFlags) {
            this.f_fieldFlags = dataSetFieldFlags;
            return this;
        }

        public UnsignedByte getBuiltInType() {
            return this.f_builtInType;
        }

        public Builder setBuiltInType(UnsignedByte unsignedByte) {
            this.f_builtInType = unsignedByte;
            return this;
        }

        public NodeId getDataType() {
            return this.f_dataType;
        }

        public Builder setDataType(NodeId nodeId) {
            this.f_dataType = nodeId;
            return this;
        }

        public Integer getValueRank() {
            return this.f_valueRank;
        }

        public Builder setValueRank(Integer n2) {
            this.f_valueRank = n2;
            return this;
        }

        public UnsignedInteger[] getArrayDimensions() {
            return this.f_arrayDimensions;
        }

        public Builder setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
            this.f_arrayDimensions = unsignedIntegerArray;
            return this;
        }

        public UnsignedInteger getMaxStringLength() {
            return this.f_maxStringLength;
        }

        public Builder setMaxStringLength(UnsignedInteger unsignedInteger) {
            this.f_maxStringLength = unsignedInteger;
            return this;
        }

        public UUID getDataSetFieldId() {
            return this.f_dataSetFieldId;
        }

        public Builder setDataSetFieldId(UUID uUID) {
            this.f_dataSetFieldId = uUID;
            return this;
        }

        public KeyValuePair[] getProperties() {
            return this.f_properties;
        }

        public Builder setProperties(KeyValuePair[] keyValuePairArray) {
            this.f_properties = keyValuePairArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getFieldFlags(), builder.getFieldFlags())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getBuiltInType(), builder.getBuiltInType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDataType(), builder.getDataType())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getValueRank(), builder.getValueRank())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getArrayDimensions(), builder.getArrayDimensions())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getMaxStringLength(), builder.getMaxStringLength())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDataSetFieldId(), builder.getDataSetFieldId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getProperties(), builder.getProperties());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getName(), this.getDescription(), this.getFieldFlags(), this.getBuiltInType(), this.getDataType(), this.getValueRank(), this.getArrayDimensions(), this.getMaxStringLength(), this.getDataSetFieldId(), this.getProperties());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            if (Fields.FieldFlags.equals(fieldSpecification)) {
                return this.getFieldFlags();
            }
            if (Fields.BuiltInType.equals(fieldSpecification)) {
                return this.getBuiltInType();
            }
            if (Fields.DataType.equals(fieldSpecification)) {
                return this.getDataType();
            }
            if (Fields.ValueRank.equals(fieldSpecification)) {
                return this.getValueRank();
            }
            if (Fields.ArrayDimensions.equals(fieldSpecification)) {
                return this.getArrayDimensions();
            }
            if (Fields.MaxStringLength.equals(fieldSpecification)) {
                return this.getMaxStringLength();
            }
            if (Fields.DataSetFieldId.equals(fieldSpecification)) {
                return this.getDataSetFieldId();
            }
            if (Fields.Properties.equals(fieldSpecification)) {
                return this.getProperties();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.FieldFlags.equals(fieldSpecification)) {
                this.setFieldFlags((DataSetFieldFlags)object);
                return this;
            }
            if (Fields.BuiltInType.equals(fieldSpecification)) {
                this.setBuiltInType((UnsignedByte)object);
                return this;
            }
            if (Fields.DataType.equals(fieldSpecification)) {
                this.setDataType((NodeId)object);
                return this;
            }
            if (Fields.ValueRank.equals(fieldSpecification)) {
                this.setValueRank((Integer)object);
                return this;
            }
            if (Fields.ArrayDimensions.equals(fieldSpecification)) {
                this.setArrayDimensions((UnsignedInteger[])object);
                return this;
            }
            if (Fields.MaxStringLength.equals(fieldSpecification)) {
                this.setMaxStringLength((UnsignedInteger)object);
                return this;
            }
            if (Fields.DataSetFieldId.equals(fieldSpecification)) {
                this.setDataSetFieldId((UUID)object);
                return this;
            }
            if (Fields.Properties.equals(fieldSpecification)) {
                this.setProperties((KeyValuePair[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_name = null;
            this.f_description = null;
            this.f_fieldFlags = null;
            this.f_builtInType = null;
            this.f_dataType = null;
            this.f_valueRank = null;
            this.f_arrayDimensions = null;
            this.f_maxStringLength = null;
            this.f_dataSetFieldId = null;
            this.f_properties = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public FieldMetaData build() {
            return new FieldMetaData(this.f_name, this.f_description, this.f_fieldFlags, this.f_builtInType, this.f_dataType, this.f_valueRank, this.f_arrayDimensions, this.f_maxStringLength, this.f_dataSetFieldId, this.f_properties);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Name("Name", String.class, false, UaIds.String, -1, null, false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        FieldFlags("FieldFlags", DataSetFieldFlags.class, false, UaIds.DataSetFieldFlags, -1, null, false),
        BuiltInType("BuiltInType", UnsignedByte.class, false, UaIds.Byte, -1, null, false),
        DataType("DataType", NodeId.class, false, UaIds.NodeId, -1, null, false),
        ValueRank("ValueRank", Integer.class, false, UaIds.Int32, -1, null, false),
        ArrayDimensions("ArrayDimensions", UnsignedInteger[].class, false, UaIds.UInt32, 1, UaArrayDimensions.valueOf(0L), false),
        MaxStringLength("MaxStringLength", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false),
        DataSetFieldId("DataSetFieldId", UUID.class, false, UaIds.Guid, -1, null, false),
        Properties("Properties", KeyValuePair[].class, false, UaIds.KeyValuePair, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

