/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=734")
public class EventFilterResult
extends MonitoringFilterResult {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventFilterResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventFilterResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventFilterResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventFilterResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode[] f_selectClauseResults;
    private DiagnosticInfo[] f_selectClauseDiagnosticInfos;
    private ContentFilterResult f_whereClauseResult;

    public EventFilterResult() {
    }

    public EventFilterResult(StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, ContentFilterResult contentFilterResult) {
        this.f_selectClauseResults = statusCodeArray;
        this.f_selectClauseDiagnosticInfos = diagnosticInfoArray;
        this.f_whereClauseResult = contentFilterResult;
    }

    public StatusCode[] getSelectClauseResults() {
        return this.f_selectClauseResults;
    }

    public void setSelectClauseResults(StatusCode[] statusCodeArray) {
        this.f_selectClauseResults = statusCodeArray;
    }

    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this.f_selectClauseDiagnosticInfos;
    }

    public void setSelectClauseDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.f_selectClauseDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.f_whereClauseResult;
    }

    public void setWhereClauseResult(ContentFilterResult contentFilterResult) {
        this.f_whereClauseResult = contentFilterResult;
    }

    @Override
    public EventFilterResult clone() {
        EventFilterResult eventFilterResult = (EventFilterResult)super.clone();
        eventFilterResult.f_selectClauseResults = StructureUtils.clone(this.f_selectClauseResults);
        eventFilterResult.f_selectClauseDiagnosticInfos = StructureUtils.clone(this.f_selectClauseDiagnosticInfos);
        eventFilterResult.f_whereClauseResult = StructureUtils.clone(this.f_whereClauseResult);
        return eventFilterResult;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFilterResult eventFilterResult = (EventFilterResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseResults(), eventFilterResult.getSelectClauseResults())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseDiagnosticInfos(), eventFilterResult.getSelectClauseDiagnosticInfos())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getWhereClauseResult(), eventFilterResult.getWhereClauseResult());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSelectClauseResults(), this.getSelectClauseDiagnosticInfos(), this.getWhereClauseResult());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_selectClauseResults = null;
        this.f_selectClauseDiagnosticInfos = null;
        this.f_whereClauseResult = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.SelectClauseResults, this.getSelectClauseResults());
        linkedHashMap.put(Fields.SelectClauseDiagnosticInfos, this.getSelectClauseDiagnosticInfos());
        linkedHashMap.put(Fields.WhereClauseResult, this.getWhereClauseResult());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SelectClauseResults.equals(fieldSpecification)) {
            return this.getSelectClauseResults();
        }
        if (Fields.SelectClauseDiagnosticInfos.equals(fieldSpecification)) {
            return this.getSelectClauseDiagnosticInfos();
        }
        if (Fields.WhereClauseResult.equals(fieldSpecification)) {
            return this.getWhereClauseResult();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SelectClauseResults.equals(fieldSpecification)) {
            this.setSelectClauseResults((StatusCode[])object);
            return;
        }
        if (Fields.SelectClauseDiagnosticInfos.equals(fieldSpecification)) {
            this.setSelectClauseDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        if (Fields.WhereClauseResult.equals(fieldSpecification)) {
            this.setWhereClauseResult((ContentFilterResult)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventFilterResult.builder();
        builder.setSelectClauseResults(StructureUtils.clone(this.getSelectClauseResults()));
        builder.setSelectClauseDiagnosticInfos(StructureUtils.clone(this.getSelectClauseDiagnosticInfos()));
        builder.setWhereClauseResult(StructureUtils.clone(this.getWhereClauseResult()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SelectClauseResults);
        builder.addField(Fields.SelectClauseDiagnosticInfos);
        builder.addField(Fields.WhereClauseResult);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.MonitoringFilterResult);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EventFilterResult");
        builder.setJavaClass(EventFilterResult.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilterResult.Builder {
        private StatusCode[] f_selectClauseResults;
        private DiagnosticInfo[] f_selectClauseDiagnosticInfos;
        private ContentFilterResult f_whereClauseResult;

        protected Builder() {
        }

        public StatusCode[] getSelectClauseResults() {
            return this.f_selectClauseResults;
        }

        public Builder setSelectClauseResults(StatusCode[] statusCodeArray) {
            this.f_selectClauseResults = statusCodeArray;
            return this;
        }

        public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
            return this.f_selectClauseDiagnosticInfos;
        }

        public Builder setSelectClauseDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.f_selectClauseDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        public ContentFilterResult getWhereClauseResult() {
            return this.f_whereClauseResult;
        }

        public Builder setWhereClauseResult(ContentFilterResult contentFilterResult) {
            this.f_whereClauseResult = contentFilterResult;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseResults(), builder.getSelectClauseResults())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseDiagnosticInfos(), builder.getSelectClauseDiagnosticInfos())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getWhereClauseResult(), builder.getWhereClauseResult());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getSelectClauseResults(), this.getSelectClauseDiagnosticInfos(), this.getWhereClauseResult());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.SelectClauseResults.equals(fieldSpecification)) {
                return this.getSelectClauseResults();
            }
            if (Fields.SelectClauseDiagnosticInfos.equals(fieldSpecification)) {
                return this.getSelectClauseDiagnosticInfos();
            }
            if (Fields.WhereClauseResult.equals(fieldSpecification)) {
                return this.getWhereClauseResult();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SelectClauseResults.equals(fieldSpecification)) {
                this.setSelectClauseResults((StatusCode[])object);
                return this;
            }
            if (Fields.SelectClauseDiagnosticInfos.equals(fieldSpecification)) {
                this.setSelectClauseDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            if (Fields.WhereClauseResult.equals(fieldSpecification)) {
                this.setWhereClauseResult((ContentFilterResult)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_selectClauseResults = null;
            this.f_selectClauseDiagnosticInfos = null;
            this.f_whereClauseResult = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EventFilterResult build() {
            return new EventFilterResult(this.f_selectClauseResults, this.f_selectClauseDiagnosticInfos, this.f_whereClauseResult);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SelectClauseResults("SelectClauseResults", StatusCode[].class, false, UaIds.StatusCode, 1, UaArrayDimensions.valueOf(0L), false),
        SelectClauseDiagnosticInfos("SelectClauseDiagnosticInfos", DiagnosticInfo[].class, false, UaIds.DiagnosticInfo, 1, UaArrayDimensions.valueOf(0L), false),
        WhereClauseResult("WhereClauseResult", ContentFilterResult.class, false, UaIds.ContentFilterResult, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

