/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=917")
public class EventFieldList
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventFieldList_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventFieldList_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventFieldList_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventFieldList;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger f_clientHandle;
    private Object[] f_eventFields;

    public EventFieldList() {
    }

    public EventFieldList(UnsignedInteger unsignedInteger, Object[] objectArray) {
        this.f_clientHandle = unsignedInteger;
        this.f_eventFields = objectArray;
    }

    public UnsignedInteger getClientHandle() {
        return this.f_clientHandle;
    }

    public void setClientHandle(UnsignedInteger unsignedInteger) {
        this.f_clientHandle = unsignedInteger;
    }

    public Object[] getEventFields() {
        return this.f_eventFields;
    }

    public void setEventFields(Object[] objectArray) {
        this.f_eventFields = objectArray;
    }

    @Override
    public EventFieldList clone() {
        EventFieldList eventFieldList = (EventFieldList)super.clone();
        eventFieldList.f_clientHandle = StructureUtils.clone(this.f_clientHandle);
        eventFieldList.f_eventFields = StructureUtils.clone(this.f_eventFields);
        return eventFieldList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFieldList eventFieldList = (EventFieldList)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getClientHandle(), eventFieldList.getClientHandle())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEventFields(), eventFieldList.getEventFields());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getClientHandle(), this.getEventFields());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_clientHandle = null;
        this.f_eventFields = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.ClientHandle, this.getClientHandle());
        linkedHashMap.put(Fields.EventFields, this.getEventFields());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ClientHandle.equals(fieldSpecification)) {
            return this.getClientHandle();
        }
        if (Fields.EventFields.equals(fieldSpecification)) {
            return this.getEventFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ClientHandle.equals(fieldSpecification)) {
            this.setClientHandle((UnsignedInteger)object);
            return;
        }
        if (Fields.EventFields.equals(fieldSpecification)) {
            this.setEventFields((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventFieldList.builder();
        builder.setClientHandle(StructureUtils.clone(this.getClientHandle()));
        builder.setEventFields(StructureUtils.clone(this.getEventFields()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.ClientHandle);
        builder.addField(Fields.EventFields);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EventFieldList");
        builder.setJavaClass(EventFieldList.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger f_clientHandle;
        private Object[] f_eventFields;

        protected Builder() {
        }

        public UnsignedInteger getClientHandle() {
            return this.f_clientHandle;
        }

        public Builder setClientHandle(UnsignedInteger unsignedInteger) {
            this.f_clientHandle = unsignedInteger;
            return this;
        }

        public Object[] getEventFields() {
            return this.f_eventFields;
        }

        public Builder setEventFields(Object[] objectArray) {
            this.f_eventFields = objectArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getClientHandle(), builder.getClientHandle())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getEventFields(), builder.getEventFields());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getClientHandle(), this.getEventFields());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.ClientHandle.equals(fieldSpecification)) {
                return this.getClientHandle();
            }
            if (Fields.EventFields.equals(fieldSpecification)) {
                return this.getEventFields();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ClientHandle.equals(fieldSpecification)) {
                this.setClientHandle((UnsignedInteger)object);
                return this;
            }
            if (Fields.EventFields.equals(fieldSpecification)) {
                this.setEventFields((Object[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_clientHandle = null;
            this.f_eventFields = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EventFieldList build() {
            return new EventFieldList(this.f_clientHandle, this.f_eventFields);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        ClientHandle("ClientHandle", UnsignedInteger.class, false, UaIds.IntegerId, -1, null, false),
        EventFields("EventFields", Object[].class, false, UaIds.BaseDataType, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

