/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17548")
public class EphemeralKeyType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EphemeralKeyType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EphemeralKeyType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EphemeralKeyType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EphemeralKeyType;
    public static final StructureSpecification SPECIFICATION;
    private ByteString f_publicKey;
    private ByteString f_signature;

    public EphemeralKeyType() {
    }

    public EphemeralKeyType(ByteString byteString, ByteString byteString2) {
        this.f_publicKey = byteString;
        this.f_signature = byteString2;
    }

    public ByteString getPublicKey() {
        return this.f_publicKey;
    }

    public void setPublicKey(ByteString byteString) {
        this.f_publicKey = byteString;
    }

    public ByteString getSignature() {
        return this.f_signature;
    }

    public void setSignature(ByteString byteString) {
        this.f_signature = byteString;
    }

    @Override
    public EphemeralKeyType clone() {
        EphemeralKeyType ephemeralKeyType = (EphemeralKeyType)super.clone();
        ephemeralKeyType.f_publicKey = StructureUtils.clone(this.f_publicKey);
        ephemeralKeyType.f_signature = StructureUtils.clone(this.f_signature);
        return ephemeralKeyType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EphemeralKeyType ephemeralKeyType = (EphemeralKeyType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPublicKey(), ephemeralKeyType.getPublicKey())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSignature(), ephemeralKeyType.getSignature());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getPublicKey(), this.getSignature());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_publicKey = null;
        this.f_signature = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, ByteString> linkedHashMap = new LinkedHashMap<Fields, ByteString>();
        linkedHashMap.put(Fields.PublicKey, this.getPublicKey());
        linkedHashMap.put(Fields.Signature, this.getSignature());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PublicKey.equals(fieldSpecification)) {
            return this.getPublicKey();
        }
        if (Fields.Signature.equals(fieldSpecification)) {
            return this.getSignature();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PublicKey.equals(fieldSpecification)) {
            this.setPublicKey((ByteString)object);
            return;
        }
        if (Fields.Signature.equals(fieldSpecification)) {
            this.setSignature((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EphemeralKeyType.builder();
        builder.setPublicKey(StructureUtils.clone(this.getPublicKey()));
        builder.setSignature(StructureUtils.clone(this.getSignature()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.PublicKey);
        builder.addField(Fields.Signature);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EphemeralKeyType");
        builder.setJavaClass(EphemeralKeyType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ByteString f_publicKey;
        private ByteString f_signature;

        protected Builder() {
        }

        public ByteString getPublicKey() {
            return this.f_publicKey;
        }

        public Builder setPublicKey(ByteString byteString) {
            this.f_publicKey = byteString;
            return this;
        }

        public ByteString getSignature() {
            return this.f_signature;
        }

        public Builder setSignature(ByteString byteString) {
            this.f_signature = byteString;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getPublicKey(), builder.getPublicKey())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getSignature(), builder.getSignature());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getPublicKey(), this.getSignature());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.PublicKey.equals(fieldSpecification)) {
                return this.getPublicKey();
            }
            if (Fields.Signature.equals(fieldSpecification)) {
                return this.getSignature();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PublicKey.equals(fieldSpecification)) {
                this.setPublicKey((ByteString)object);
                return this;
            }
            if (Fields.Signature.equals(fieldSpecification)) {
                this.setSignature((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_publicKey = null;
            this.f_signature = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EphemeralKeyType build() {
            return new EphemeralKeyType(this.f_publicKey, this.f_signature);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        PublicKey("PublicKey", ByteString.class, false, UaIds.ByteString, -1, null, false),
        Signature("Signature", ByteString.class, false, UaIds.ByteString, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

