/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=102")
public class EnumField
extends EnumValueType {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumField_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumField_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumField_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumField;
    public static final StructureSpecification SPECIFICATION;
    private String f_name;

    public EnumField() {
    }

    public EnumField(String string) {
        this.f_name = string;
    }

    public EnumField(Long l2, LocalizedText localizedText, LocalizedText localizedText2, String string) {
        super(l2, localizedText, localizedText2);
        this.f_name = string;
    }

    public String getName() {
        return this.f_name;
    }

    public void setName(String string) {
        this.f_name = string;
    }

    @Override
    public EnumField clone() {
        EnumField enumField = (EnumField)super.clone();
        enumField.f_name = StructureUtils.clone(this.f_name);
        return enumField;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumField enumField = (EnumField)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getValue(), enumField.getValue())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), enumField.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), enumField.getDescription())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getName(), enumField.getName());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getValue(), this.getDisplayName(), this.getDescription(), this.getName());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_name = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Value, this.getValue());
        linkedHashMap.put(Fields.DisplayName, this.getDisplayName());
        linkedHashMap.put(Fields.Description, this.getDescription());
        linkedHashMap.put(Fields.Name, this.getName());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Value.equals(fieldSpecification)) {
            return this.getValue();
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue((Long)object);
            return;
        }
        if (Fields.DisplayName.equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumField.builder();
        builder.setValue(StructureUtils.clone(this.getValue()));
        builder.setDisplayName(StructureUtils.clone(this.getDisplayName()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        builder.setName(StructureUtils.clone(this.getName()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Value);
        builder.addField(Fields.DisplayName);
        builder.addField(Fields.Description);
        builder.addField(Fields.Name);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.EnumValueType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EnumField");
        builder.setJavaClass(EnumField.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends EnumValueType.Builder {
        private Long f_value;
        private LocalizedText f_displayName;
        private LocalizedText f_description;
        private String f_name;

        protected Builder() {
        }

        @Override
        public Long getValue() {
            return this.f_value;
        }

        @Override
        public Builder setValue(Long l2) {
            this.f_value = l2;
            return this;
        }

        @Override
        public LocalizedText getDisplayName() {
            return this.f_displayName;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.f_displayName = localizedText;
            return this;
        }

        @Override
        public LocalizedText getDescription() {
            return this.f_description;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        public String getName() {
            return this.f_name;
        }

        public Builder setName(String string) {
            this.f_name = string;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getValue(), builder.getValue())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), builder.getDisplayName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getValue(), this.getDisplayName(), this.getDescription(), this.getName());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Value.equals(fieldSpecification)) {
                return this.getValue();
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                return this.getDisplayName();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue((Long)object);
                return this;
            }
            if (Fields.DisplayName.equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_name = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EnumField build() {
            return new EnumField(this.f_value, this.f_displayName, this.f_description, this.f_name);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Value("Value", Long.class, false, UaIds.Int64, -1, null, false),
        DisplayName("DisplayName", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        Name("Name", String.class, false, UaIds.String, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

