/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.DataTypeDescription;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15488")
public class EnumDescription
extends DataTypeDescription {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumDescription;
    public static final StructureSpecification SPECIFICATION;
    private EnumDefinition f_enumDefinition;
    private UnsignedByte f_builtInType;

    public EnumDescription() {
    }

    public EnumDescription(EnumDefinition enumDefinition, UnsignedByte unsignedByte) {
        this.f_enumDefinition = enumDefinition;
        this.f_builtInType = unsignedByte;
    }

    public EnumDescription(NodeId nodeId, QualifiedName qualifiedName, EnumDefinition enumDefinition, UnsignedByte unsignedByte) {
        super(nodeId, qualifiedName);
        this.f_enumDefinition = enumDefinition;
        this.f_builtInType = unsignedByte;
    }

    public EnumDefinition getEnumDefinition() {
        return this.f_enumDefinition;
    }

    public void setEnumDefinition(EnumDefinition enumDefinition) {
        this.f_enumDefinition = enumDefinition;
    }

    public UnsignedByte getBuiltInType() {
        return this.f_builtInType;
    }

    public void setBuiltInType(UnsignedByte unsignedByte) {
        this.f_builtInType = unsignedByte;
    }

    @Override
    public EnumDescription clone() {
        EnumDescription enumDescription = (EnumDescription)super.clone();
        enumDescription.f_enumDefinition = StructureUtils.clone(this.f_enumDefinition);
        enumDescription.f_builtInType = StructureUtils.clone(this.f_builtInType);
        return enumDescription;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumDescription enumDescription = (EnumDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), enumDescription.getDataTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), enumDescription.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnumDefinition(), enumDescription.getEnumDefinition())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getBuiltInType(), enumDescription.getBuiltInType());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getEnumDefinition(), this.getBuiltInType());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_enumDefinition = null;
        this.f_builtInType = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.DataTypeId, this.getDataTypeId());
        linkedHashMap.put(Fields.Name, this.getName());
        linkedHashMap.put(Fields.EnumDefinition, this.getEnumDefinition());
        linkedHashMap.put(Fields.BuiltInType, this.getBuiltInType());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataTypeId.equals(fieldSpecification)) {
            return this.getDataTypeId();
        }
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.EnumDefinition.equals(fieldSpecification)) {
            return this.getEnumDefinition();
        }
        if (Fields.BuiltInType.equals(fieldSpecification)) {
            return this.getBuiltInType();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataTypeId.equals(fieldSpecification)) {
            this.setDataTypeId((NodeId)object);
            return;
        }
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((QualifiedName)object);
            return;
        }
        if (Fields.EnumDefinition.equals(fieldSpecification)) {
            this.setEnumDefinition((EnumDefinition)object);
            return;
        }
        if (Fields.BuiltInType.equals(fieldSpecification)) {
            this.setBuiltInType((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumDescription.builder();
        builder.setDataTypeId(StructureUtils.clone(this.getDataTypeId()));
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setEnumDefinition(StructureUtils.clone(this.getEnumDefinition()));
        builder.setBuiltInType(StructureUtils.clone(this.getBuiltInType()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.DataTypeId);
        builder.addField(Fields.Name);
        builder.addField(Fields.EnumDefinition);
        builder.addField(Fields.BuiltInType);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DataTypeDescription);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EnumDescription");
        builder.setJavaClass(EnumDescription.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDescription.Builder {
        private NodeId f_dataTypeId;
        private QualifiedName f_name;
        private EnumDefinition f_enumDefinition;
        private UnsignedByte f_builtInType;

        protected Builder() {
        }

        @Override
        public NodeId getDataTypeId() {
            return this.f_dataTypeId;
        }

        @Override
        public Builder setDataTypeId(NodeId nodeId) {
            this.f_dataTypeId = nodeId;
            return this;
        }

        @Override
        public QualifiedName getName() {
            return this.f_name;
        }

        @Override
        public Builder setName(QualifiedName qualifiedName) {
            this.f_name = qualifiedName;
            return this;
        }

        public EnumDefinition getEnumDefinition() {
            return this.f_enumDefinition;
        }

        public Builder setEnumDefinition(EnumDefinition enumDefinition) {
            this.f_enumDefinition = enumDefinition;
            return this;
        }

        public UnsignedByte getBuiltInType() {
            return this.f_builtInType;
        }

        public Builder setBuiltInType(UnsignedByte unsignedByte) {
            this.f_builtInType = unsignedByte;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), builder.getDataTypeId())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getEnumDefinition(), builder.getEnumDefinition())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getBuiltInType(), builder.getBuiltInType());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getEnumDefinition(), this.getBuiltInType());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.DataTypeId.equals(fieldSpecification)) {
                return this.getDataTypeId();
            }
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.EnumDefinition.equals(fieldSpecification)) {
                return this.getEnumDefinition();
            }
            if (Fields.BuiltInType.equals(fieldSpecification)) {
                return this.getBuiltInType();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataTypeId.equals(fieldSpecification)) {
                this.setDataTypeId((NodeId)object);
                return this;
            }
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((QualifiedName)object);
                return this;
            }
            if (Fields.EnumDefinition.equals(fieldSpecification)) {
                this.setEnumDefinition((EnumDefinition)object);
                return this;
            }
            if (Fields.BuiltInType.equals(fieldSpecification)) {
                this.setBuiltInType((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_enumDefinition = null;
            this.f_builtInType = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EnumDescription build() {
            return new EnumDescription(this.f_dataTypeId, this.f_name, this.f_enumDefinition, this.f_builtInType);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        DataTypeId("DataTypeId", NodeId.class, false, UaIds.NodeId, -1, null, false),
        Name("Name", QualifiedName.class, false, UaIds.QualifiedName, -1, null, false),
        EnumDefinition("EnumDefinition", EnumDefinition.class, false, UaIds.EnumDefinition, -1, null, false),
        BuiltInType("BuiltInType", UnsignedByte.class, false, UaIds.Byte, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

