/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=100")
public class EnumDefinition
extends DataTypeDefinition {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumDefinition_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumDefinition_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumDefinition_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumDefinition;
    public static final StructureSpecification SPECIFICATION;
    private EnumField[] f_fields;

    public EnumDefinition() {
    }

    public EnumDefinition(EnumField[] enumFieldArray) {
        this.f_fields = enumFieldArray;
    }

    public EnumField[] getFields() {
        return this.f_fields;
    }

    public void setFields(EnumField[] enumFieldArray) {
        this.f_fields = enumFieldArray;
    }

    @Override
    public EnumDefinition clone() {
        EnumDefinition enumDefinition = (EnumDefinition)super.clone();
        enumDefinition.f_fields = StructureUtils.clone(this.f_fields);
        return enumDefinition;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumDefinition enumDefinition = (EnumDefinition)object;
        return StructureUtils.scalarOrArrayEquals(this.getFields(), enumDefinition.getFields());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getFields());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_fields = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, EnumField[]> linkedHashMap = new LinkedHashMap<Fields, EnumField[]>();
        linkedHashMap.put(Fields.Fields, this.getFields());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Fields.equals(fieldSpecification)) {
            return this.getFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Fields.equals(fieldSpecification)) {
            this.setFields((EnumField[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumDefinition.builder();
        builder.setFields(StructureUtils.clone(this.getFields()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Fields);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DataTypeDefinition);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EnumDefinition");
        builder.setJavaClass(EnumDefinition.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDefinition.Builder {
        private EnumField[] f_fields;

        protected Builder() {
        }

        public EnumField[] getFields() {
            return this.f_fields;
        }

        public Builder setFields(EnumField[] enumFieldArray) {
            this.f_fields = enumFieldArray;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            return StructureUtils.scalarOrArrayEquals(this.getFields(), builder.getFields());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getFields());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Fields.equals(fieldSpecification)) {
                return this.getFields();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Fields.equals(fieldSpecification)) {
                this.setFields((EnumField[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_fields = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EnumDefinition build() {
            return new EnumDefinition(this.f_fields);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Fields("Fields", EnumField[].class, false, UaIds.EnumField, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

