/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15528")
public class EndpointType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EndpointType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EndpointType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EndpointType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EndpointType;
    public static final StructureSpecification SPECIFICATION;
    private String f_endpointUrl;
    private MessageSecurityMode f_securityMode;
    private String f_securityPolicyUri;
    private String f_transportProfileUri;

    public EndpointType() {
    }

    public EndpointType(String string, MessageSecurityMode messageSecurityMode, String string2, String string3) {
        this.f_endpointUrl = string;
        this.f_securityMode = messageSecurityMode;
        this.f_securityPolicyUri = string2;
        this.f_transportProfileUri = string3;
    }

    public String getEndpointUrl() {
        return this.f_endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.f_endpointUrl = string;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.f_securityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.f_securityMode = messageSecurityMode;
    }

    public String getSecurityPolicyUri() {
        return this.f_securityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.f_securityPolicyUri = string;
    }

    public String getTransportProfileUri() {
        return this.f_transportProfileUri;
    }

    public void setTransportProfileUri(String string) {
        this.f_transportProfileUri = string;
    }

    @Override
    public EndpointType clone() {
        EndpointType endpointType = (EndpointType)super.clone();
        endpointType.f_endpointUrl = StructureUtils.clone(this.f_endpointUrl);
        endpointType.f_securityMode = StructureUtils.clone(this.f_securityMode);
        endpointType.f_securityPolicyUri = StructureUtils.clone(this.f_securityPolicyUri);
        endpointType.f_transportProfileUri = StructureUtils.clone(this.f_transportProfileUri);
        return endpointType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointType endpointType = (EndpointType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), endpointType.getEndpointUrl())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), endpointType.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), endpointType.getSecurityPolicyUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), endpointType.getTransportProfileUri());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEndpointUrl(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getTransportProfileUri());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_endpointUrl = null;
        this.f_securityMode = null;
        this.f_securityPolicyUri = null;
        this.f_transportProfileUri = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.EndpointUrl, this.getEndpointUrl());
        linkedHashMap.put(Fields.SecurityMode, this.getSecurityMode());
        linkedHashMap.put(Fields.SecurityPolicyUri, this.getSecurityPolicyUri());
        linkedHashMap.put(Fields.TransportProfileUri, this.getTransportProfileUri());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EndpointUrl.equals(fieldSpecification)) {
            return this.getEndpointUrl();
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
            return this.getSecurityPolicyUri();
        }
        if (Fields.TransportProfileUri.equals(fieldSpecification)) {
            return this.getTransportProfileUri();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EndpointUrl.equals(fieldSpecification)) {
            this.setEndpointUrl((String)object);
            return;
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
            this.setSecurityPolicyUri((String)object);
            return;
        }
        if (Fields.TransportProfileUri.equals(fieldSpecification)) {
            this.setTransportProfileUri((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EndpointType.builder();
        builder.setEndpointUrl(StructureUtils.clone(this.getEndpointUrl()));
        builder.setSecurityMode(StructureUtils.clone(this.getSecurityMode()));
        builder.setSecurityPolicyUri(StructureUtils.clone(this.getSecurityPolicyUri()));
        builder.setTransportProfileUri(StructureUtils.clone(this.getTransportProfileUri()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.EndpointUrl);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.SecurityPolicyUri);
        builder.addField(Fields.TransportProfileUri);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EndpointType");
        builder.setJavaClass(EndpointType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_endpointUrl;
        private MessageSecurityMode f_securityMode;
        private String f_securityPolicyUri;
        private String f_transportProfileUri;

        protected Builder() {
        }

        public String getEndpointUrl() {
            return this.f_endpointUrl;
        }

        public Builder setEndpointUrl(String string) {
            this.f_endpointUrl = string;
            return this;
        }

        public MessageSecurityMode getSecurityMode() {
            return this.f_securityMode;
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.f_securityMode = messageSecurityMode;
            return this;
        }

        public String getSecurityPolicyUri() {
            return this.f_securityPolicyUri;
        }

        public Builder setSecurityPolicyUri(String string) {
            this.f_securityPolicyUri = string;
            return this;
        }

        public String getTransportProfileUri() {
            return this.f_transportProfileUri;
        }

        public Builder setTransportProfileUri(String string) {
            this.f_transportProfileUri = string;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), builder.getEndpointUrl())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), builder.getSecurityMode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), builder.getSecurityPolicyUri())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), builder.getTransportProfileUri());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getEndpointUrl(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getTransportProfileUri());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.EndpointUrl.equals(fieldSpecification)) {
                return this.getEndpointUrl();
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                return this.getSecurityMode();
            }
            if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
                return this.getSecurityPolicyUri();
            }
            if (Fields.TransportProfileUri.equals(fieldSpecification)) {
                return this.getTransportProfileUri();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EndpointUrl.equals(fieldSpecification)) {
                this.setEndpointUrl((String)object);
                return this;
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
                this.setSecurityPolicyUri((String)object);
                return this;
            }
            if (Fields.TransportProfileUri.equals(fieldSpecification)) {
                this.setTransportProfileUri((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_endpointUrl = null;
            this.f_securityMode = null;
            this.f_securityPolicyUri = null;
            this.f_transportProfileUri = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EndpointType build() {
            return new EndpointType(this.f_endpointUrl, this.f_securityMode, this.f_securityPolicyUri, this.f_transportProfileUri);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        EndpointUrl("EndpointUrl", String.class, false, UaIds.String, -1, null, false),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false),
        SecurityPolicyUri("SecurityPolicyUri", String.class, false, UaIds.String, -1, null, false),
        TransportProfileUri("TransportProfileUri", String.class, false, UaIds.String, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

