/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=312")
public class EndpointDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EndpointDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EndpointDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EndpointDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EndpointDescription;
    public static final StructureSpecification SPECIFICATION;
    private String f_endpointUrl;
    private ApplicationDescription f_server;
    private ByteString f_serverCertificate;
    private MessageSecurityMode f_securityMode;
    private String f_securityPolicyUri;
    private UserTokenPolicy[] f_userIdentityTokens;
    private String f_transportProfileUri;
    private UnsignedByte f_securityLevel;

    public EndpointDescription() {
    }

    public EndpointDescription(String string, ApplicationDescription applicationDescription, ByteString byteString, MessageSecurityMode messageSecurityMode, String string2, UserTokenPolicy[] userTokenPolicyArray, String string3, UnsignedByte unsignedByte) {
        this.f_endpointUrl = string;
        this.f_server = applicationDescription;
        this.f_serverCertificate = byteString;
        this.f_securityMode = messageSecurityMode;
        this.f_securityPolicyUri = string2;
        this.f_userIdentityTokens = userTokenPolicyArray;
        this.f_transportProfileUri = string3;
        this.f_securityLevel = unsignedByte;
    }

    public String getEndpointUrl() {
        return this.f_endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.f_endpointUrl = string;
    }

    public ApplicationDescription getServer() {
        return this.f_server;
    }

    public void setServer(ApplicationDescription applicationDescription) {
        this.f_server = applicationDescription;
    }

    public ByteString getServerCertificate() {
        return this.f_serverCertificate;
    }

    public void setServerCertificate(ByteString byteString) {
        this.f_serverCertificate = byteString;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.f_securityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.f_securityMode = messageSecurityMode;
    }

    public String getSecurityPolicyUri() {
        return this.f_securityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.f_securityPolicyUri = string;
    }

    public UserTokenPolicy[] getUserIdentityTokens() {
        return this.f_userIdentityTokens;
    }

    public void setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
        this.f_userIdentityTokens = userTokenPolicyArray;
    }

    public String getTransportProfileUri() {
        return this.f_transportProfileUri;
    }

    public void setTransportProfileUri(String string) {
        this.f_transportProfileUri = string;
    }

    public UnsignedByte getSecurityLevel() {
        return this.f_securityLevel;
    }

    public void setSecurityLevel(UnsignedByte unsignedByte) {
        this.f_securityLevel = unsignedByte;
    }

    @Override
    public EndpointDescription clone() {
        EndpointDescription endpointDescription = (EndpointDescription)super.clone();
        endpointDescription.f_endpointUrl = StructureUtils.clone(this.f_endpointUrl);
        endpointDescription.f_server = StructureUtils.clone(this.f_server);
        endpointDescription.f_serverCertificate = StructureUtils.clone(this.f_serverCertificate);
        endpointDescription.f_securityMode = StructureUtils.clone(this.f_securityMode);
        endpointDescription.f_securityPolicyUri = StructureUtils.clone(this.f_securityPolicyUri);
        endpointDescription.f_userIdentityTokens = StructureUtils.clone(this.f_userIdentityTokens);
        endpointDescription.f_transportProfileUri = StructureUtils.clone(this.f_transportProfileUri);
        endpointDescription.f_securityLevel = StructureUtils.clone(this.f_securityLevel);
        return endpointDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointDescription endpointDescription = (EndpointDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), endpointDescription.getEndpointUrl())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServer(), endpointDescription.getServer())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServerCertificate(), endpointDescription.getServerCertificate())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), endpointDescription.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), endpointDescription.getSecurityPolicyUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserIdentityTokens(), endpointDescription.getUserIdentityTokens())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), endpointDescription.getTransportProfileUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSecurityLevel(), endpointDescription.getSecurityLevel());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEndpointUrl(), this.getServer(), this.getServerCertificate(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getUserIdentityTokens(), this.getTransportProfileUri(), this.getSecurityLevel());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_endpointUrl = null;
        this.f_server = null;
        this.f_serverCertificate = null;
        this.f_securityMode = null;
        this.f_securityPolicyUri = null;
        this.f_userIdentityTokens = null;
        this.f_transportProfileUri = null;
        this.f_securityLevel = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.EndpointUrl, this.getEndpointUrl());
        linkedHashMap.put(Fields.Server, this.getServer());
        linkedHashMap.put(Fields.ServerCertificate, this.getServerCertificate());
        linkedHashMap.put(Fields.SecurityMode, this.getSecurityMode());
        linkedHashMap.put(Fields.SecurityPolicyUri, this.getSecurityPolicyUri());
        linkedHashMap.put(Fields.UserIdentityTokens, this.getUserIdentityTokens());
        linkedHashMap.put(Fields.TransportProfileUri, this.getTransportProfileUri());
        linkedHashMap.put(Fields.SecurityLevel, this.getSecurityLevel());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EndpointUrl.equals(fieldSpecification)) {
            return this.getEndpointUrl();
        }
        if (Fields.Server.equals(fieldSpecification)) {
            return this.getServer();
        }
        if (Fields.ServerCertificate.equals(fieldSpecification)) {
            return this.getServerCertificate();
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
            return this.getSecurityPolicyUri();
        }
        if (Fields.UserIdentityTokens.equals(fieldSpecification)) {
            return this.getUserIdentityTokens();
        }
        if (Fields.TransportProfileUri.equals(fieldSpecification)) {
            return this.getTransportProfileUri();
        }
        if (Fields.SecurityLevel.equals(fieldSpecification)) {
            return this.getSecurityLevel();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EndpointUrl.equals(fieldSpecification)) {
            this.setEndpointUrl((String)object);
            return;
        }
        if (Fields.Server.equals(fieldSpecification)) {
            this.setServer((ApplicationDescription)object);
            return;
        }
        if (Fields.ServerCertificate.equals(fieldSpecification)) {
            this.setServerCertificate((ByteString)object);
            return;
        }
        if (Fields.SecurityMode.equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
            this.setSecurityPolicyUri((String)object);
            return;
        }
        if (Fields.UserIdentityTokens.equals(fieldSpecification)) {
            this.setUserIdentityTokens((UserTokenPolicy[])object);
            return;
        }
        if (Fields.TransportProfileUri.equals(fieldSpecification)) {
            this.setTransportProfileUri((String)object);
            return;
        }
        if (Fields.SecurityLevel.equals(fieldSpecification)) {
            this.setSecurityLevel((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EndpointDescription.builder();
        builder.setEndpointUrl(StructureUtils.clone(this.getEndpointUrl()));
        builder.setServer(StructureUtils.clone(this.getServer()));
        builder.setServerCertificate(StructureUtils.clone(this.getServerCertificate()));
        builder.setSecurityMode(StructureUtils.clone(this.getSecurityMode()));
        builder.setSecurityPolicyUri(StructureUtils.clone(this.getSecurityPolicyUri()));
        builder.setUserIdentityTokens(StructureUtils.clone(this.getUserIdentityTokens()));
        builder.setTransportProfileUri(StructureUtils.clone(this.getTransportProfileUri()));
        builder.setSecurityLevel(StructureUtils.clone(this.getSecurityLevel()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.EndpointUrl);
        builder.addField(Fields.Server);
        builder.addField(Fields.ServerCertificate);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.SecurityPolicyUri);
        builder.addField(Fields.UserIdentityTokens);
        builder.addField(Fields.TransportProfileUri);
        builder.addField(Fields.SecurityLevel);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EndpointDescription");
        builder.setJavaClass(EndpointDescription.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_endpointUrl;
        private ApplicationDescription f_server;
        private ByteString f_serverCertificate;
        private MessageSecurityMode f_securityMode;
        private String f_securityPolicyUri;
        private UserTokenPolicy[] f_userIdentityTokens;
        private String f_transportProfileUri;
        private UnsignedByte f_securityLevel;

        protected Builder() {
        }

        public String getEndpointUrl() {
            return this.f_endpointUrl;
        }

        public Builder setEndpointUrl(String string) {
            this.f_endpointUrl = string;
            return this;
        }

        public ApplicationDescription getServer() {
            return this.f_server;
        }

        public Builder setServer(ApplicationDescription applicationDescription) {
            this.f_server = applicationDescription;
            return this;
        }

        public ByteString getServerCertificate() {
            return this.f_serverCertificate;
        }

        public Builder setServerCertificate(ByteString byteString) {
            this.f_serverCertificate = byteString;
            return this;
        }

        public MessageSecurityMode getSecurityMode() {
            return this.f_securityMode;
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.f_securityMode = messageSecurityMode;
            return this;
        }

        public String getSecurityPolicyUri() {
            return this.f_securityPolicyUri;
        }

        public Builder setSecurityPolicyUri(String string) {
            this.f_securityPolicyUri = string;
            return this;
        }

        public UserTokenPolicy[] getUserIdentityTokens() {
            return this.f_userIdentityTokens;
        }

        public Builder setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
            this.f_userIdentityTokens = userTokenPolicyArray;
            return this;
        }

        public String getTransportProfileUri() {
            return this.f_transportProfileUri;
        }

        public Builder setTransportProfileUri(String string) {
            this.f_transportProfileUri = string;
            return this;
        }

        public UnsignedByte getSecurityLevel() {
            return this.f_securityLevel;
        }

        public Builder setSecurityLevel(UnsignedByte unsignedByte) {
            this.f_securityLevel = unsignedByte;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), builder.getEndpointUrl())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getServer(), builder.getServer())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getServerCertificate(), builder.getServerCertificate())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), builder.getSecurityMode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), builder.getSecurityPolicyUri())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getUserIdentityTokens(), builder.getUserIdentityTokens())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), builder.getTransportProfileUri())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getSecurityLevel(), builder.getSecurityLevel());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getEndpointUrl(), this.getServer(), this.getServerCertificate(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getUserIdentityTokens(), this.getTransportProfileUri(), this.getSecurityLevel());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.EndpointUrl.equals(fieldSpecification)) {
                return this.getEndpointUrl();
            }
            if (Fields.Server.equals(fieldSpecification)) {
                return this.getServer();
            }
            if (Fields.ServerCertificate.equals(fieldSpecification)) {
                return this.getServerCertificate();
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                return this.getSecurityMode();
            }
            if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
                return this.getSecurityPolicyUri();
            }
            if (Fields.UserIdentityTokens.equals(fieldSpecification)) {
                return this.getUserIdentityTokens();
            }
            if (Fields.TransportProfileUri.equals(fieldSpecification)) {
                return this.getTransportProfileUri();
            }
            if (Fields.SecurityLevel.equals(fieldSpecification)) {
                return this.getSecurityLevel();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EndpointUrl.equals(fieldSpecification)) {
                this.setEndpointUrl((String)object);
                return this;
            }
            if (Fields.Server.equals(fieldSpecification)) {
                this.setServer((ApplicationDescription)object);
                return this;
            }
            if (Fields.ServerCertificate.equals(fieldSpecification)) {
                this.setServerCertificate((ByteString)object);
                return this;
            }
            if (Fields.SecurityMode.equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.SecurityPolicyUri.equals(fieldSpecification)) {
                this.setSecurityPolicyUri((String)object);
                return this;
            }
            if (Fields.UserIdentityTokens.equals(fieldSpecification)) {
                this.setUserIdentityTokens((UserTokenPolicy[])object);
                return this;
            }
            if (Fields.TransportProfileUri.equals(fieldSpecification)) {
                this.setTransportProfileUri((String)object);
                return this;
            }
            if (Fields.SecurityLevel.equals(fieldSpecification)) {
                this.setSecurityLevel((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_endpointUrl = null;
            this.f_server = null;
            this.f_serverCertificate = null;
            this.f_securityMode = null;
            this.f_securityPolicyUri = null;
            this.f_userIdentityTokens = null;
            this.f_transportProfileUri = null;
            this.f_securityLevel = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public EndpointDescription build() {
            return new EndpointDescription(this.f_endpointUrl, this.f_server, this.f_serverCertificate, this.f_securityMode, this.f_securityPolicyUri, this.f_userIdentityTokens, this.f_transportProfileUri, this.f_securityLevel);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        EndpointUrl("EndpointUrl", String.class, false, UaIds.String, -1, null, false),
        Server("Server", ApplicationDescription.class, false, UaIds.ApplicationDescription, -1, null, false),
        ServerCertificate("ServerCertificate", ByteString.class, false, UaIds.ApplicationInstanceCertificate, -1, null, false),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false),
        SecurityPolicyUri("SecurityPolicyUri", String.class, false, UaIds.String, -1, null, false),
        UserIdentityTokens("UserIdentityTokens", UserTokenPolicy[].class, false, UaIds.UserTokenPolicy, 1, UaArrayDimensions.valueOf(0L), false),
        TransportProfileUri("TransportProfileUri", String.class, false, UaIds.String, -1, null, false),
        SecurityLevel("SecurityLevel", UnsignedByte.class, false, UaIds.Byte, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

