/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=592")
public class ElementOperand
extends FilterOperand {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ElementOperand_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ElementOperand_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ElementOperand_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ElementOperand;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger f_index;

    public ElementOperand() {
    }

    public ElementOperand(UnsignedInteger unsignedInteger) {
        this.f_index = unsignedInteger;
    }

    public UnsignedInteger getIndex() {
        return this.f_index;
    }

    public void setIndex(UnsignedInteger unsignedInteger) {
        this.f_index = unsignedInteger;
    }

    @Override
    public ElementOperand clone() {
        ElementOperand elementOperand = (ElementOperand)super.clone();
        elementOperand.f_index = StructureUtils.clone(this.f_index);
        return elementOperand;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ElementOperand elementOperand = (ElementOperand)object;
        return StructureUtils.scalarOrArrayEquals(this.getIndex(), elementOperand.getIndex());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getIndex());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_index = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, UnsignedInteger> linkedHashMap = new LinkedHashMap<Fields, UnsignedInteger>();
        linkedHashMap.put(Fields.Index, this.getIndex());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Index.equals(fieldSpecification)) {
            return this.getIndex();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Index.equals(fieldSpecification)) {
            this.setIndex((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ElementOperand.builder();
        builder.setIndex(StructureUtils.clone(this.getIndex()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Index);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.FilterOperand);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ElementOperand");
        builder.setJavaClass(ElementOperand.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends FilterOperand.Builder {
        private UnsignedInteger f_index;

        protected Builder() {
        }

        public UnsignedInteger getIndex() {
            return this.f_index;
        }

        public Builder setIndex(UnsignedInteger unsignedInteger) {
            this.f_index = unsignedInteger;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            return StructureUtils.scalarOrArrayEquals(this.getIndex(), builder.getIndex());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getIndex());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Index.equals(fieldSpecification)) {
                return this.getIndex();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Index.equals(fieldSpecification)) {
                this.setIndex((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_index = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public ElementOperand build() {
            return new ElementOperand(this.f_index);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Index("Index", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

