/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12172")
public class DoubleComplexNumberType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DoubleComplexNumberType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DoubleComplexNumberType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DoubleComplexNumberType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DoubleComplexNumberType;
    public static final StructureSpecification SPECIFICATION;
    private Double f_real;
    private Double f_imaginary;

    public DoubleComplexNumberType() {
    }

    public DoubleComplexNumberType(Double d2, Double d3) {
        this.f_real = d2;
        this.f_imaginary = d3;
    }

    public Double getReal() {
        return this.f_real;
    }

    public void setReal(Double d2) {
        this.f_real = d2;
    }

    public Double getImaginary() {
        return this.f_imaginary;
    }

    public void setImaginary(Double d2) {
        this.f_imaginary = d2;
    }

    @Override
    public DoubleComplexNumberType clone() {
        DoubleComplexNumberType doubleComplexNumberType = (DoubleComplexNumberType)super.clone();
        doubleComplexNumberType.f_real = StructureUtils.clone(this.f_real);
        doubleComplexNumberType.f_imaginary = StructureUtils.clone(this.f_imaginary);
        return doubleComplexNumberType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleComplexNumberType doubleComplexNumberType = (DoubleComplexNumberType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReal(), doubleComplexNumberType.getReal())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getImaginary(), doubleComplexNumberType.getImaginary());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getReal(), this.getImaginary());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_real = null;
        this.f_imaginary = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Double> linkedHashMap = new LinkedHashMap<Fields, Double>();
        linkedHashMap.put(Fields.Real, this.getReal());
        linkedHashMap.put(Fields.Imaginary, this.getImaginary());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Real.equals(fieldSpecification)) {
            return this.getReal();
        }
        if (Fields.Imaginary.equals(fieldSpecification)) {
            return this.getImaginary();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Real.equals(fieldSpecification)) {
            this.setReal((Double)object);
            return;
        }
        if (Fields.Imaginary.equals(fieldSpecification)) {
            this.setImaginary((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DoubleComplexNumberType.builder();
        builder.setReal(StructureUtils.clone(this.getReal()));
        builder.setImaginary(StructureUtils.clone(this.getImaginary()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Real);
        builder.addField(Fields.Imaginary);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("DoubleComplexNumberType");
        builder.setJavaClass(DoubleComplexNumberType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double f_real;
        private Double f_imaginary;

        protected Builder() {
        }

        public Double getReal() {
            return this.f_real;
        }

        public Builder setReal(Double d2) {
            this.f_real = d2;
            return this;
        }

        public Double getImaginary() {
            return this.f_imaginary;
        }

        public Builder setImaginary(Double d2) {
            this.f_imaginary = d2;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getReal(), builder.getReal())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getImaginary(), builder.getImaginary());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getReal(), this.getImaginary());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Real.equals(fieldSpecification)) {
                return this.getReal();
            }
            if (Fields.Imaginary.equals(fieldSpecification)) {
                return this.getImaginary();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Real.equals(fieldSpecification)) {
                this.setReal((Double)object);
                return this;
            }
            if (Fields.Imaginary.equals(fieldSpecification)) {
                this.setImaginary((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_real = null;
            this.f_imaginary = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public DoubleComplexNumberType build() {
            return new DoubleComplexNumberType(this.f_real, this.f_imaginary);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Real("Real", Double.class, false, UaIds.Double, -1, null, false),
        Imaginary("Imaginary", Double.class, false, UaIds.Double, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

