/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19723")
public enum DiagnosticsLevel implements Enumeration
{
    Basic(0),
    Advanced(1),
    Info(2),
    Log(3),
    Debug(4);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<DiagnosticsLevel> NONE;
    public static final EnumSet<DiagnosticsLevel> ALL;
    private static final Map<Integer, DiagnosticsLevel> map;
    private final int value;

    private DiagnosticsLevel(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static DiagnosticsLevel valueOf(int n2) {
        return map.get(n2);
    }

    public static DiagnosticsLevel valueOf(Integer n2) {
        return n2 == null ? null : DiagnosticsLevel.valueOf((int)n2);
    }

    public static DiagnosticsLevel valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : DiagnosticsLevel.valueOf(unsignedInteger.intValue());
    }

    public static DiagnosticsLevel[] valueOf(int[] nArray) {
        DiagnosticsLevel[] diagnosticsLevelArray = new DiagnosticsLevel[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            diagnosticsLevelArray[i2] = DiagnosticsLevel.valueOf(nArray[i2]);
        }
        return diagnosticsLevelArray;
    }

    public static DiagnosticsLevel[] valueOf(Integer[] integerArray) {
        DiagnosticsLevel[] diagnosticsLevelArray = new DiagnosticsLevel[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            diagnosticsLevelArray[i2] = DiagnosticsLevel.valueOf(integerArray[i2]);
        }
        return diagnosticsLevelArray;
    }

    public static DiagnosticsLevel[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        DiagnosticsLevel[] diagnosticsLevelArray = new DiagnosticsLevel[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            diagnosticsLevelArray[i2] = DiagnosticsLevel.valueOf(unsignedIntegerArray[i2]);
        }
        return diagnosticsLevelArray;
    }

    public static UnsignedInteger getMask(DiagnosticsLevel ... diagnosticsLevelArray) {
        int n2 = 0;
        for (DiagnosticsLevel diagnosticsLevel : diagnosticsLevelArray) {
            n2 |= diagnosticsLevel.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<DiagnosticsLevel> collection) {
        int n2 = 0;
        for (DiagnosticsLevel diagnosticsLevel : collection) {
            n2 |= diagnosticsLevel.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<DiagnosticsLevel> getSet(UnsignedInteger unsignedInteger) {
        return DiagnosticsLevel.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<DiagnosticsLevel> getSet(int n2) {
        ArrayList<DiagnosticsLevel> arrayList = new ArrayList<DiagnosticsLevel>();
        for (DiagnosticsLevel diagnosticsLevel : DiagnosticsLevel.values()) {
            if ((n2 & diagnosticsLevel.value) != diagnosticsLevel.value) continue;
            arrayList.add(diagnosticsLevel);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DiagnosticsLevel.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(DiagnosticsLevel.class);
        ALL = EnumSet.allOf(DiagnosticsLevel.class);
        map = new HashMap<Integer, DiagnosticsLevel>();
        for (DiagnosticsLevel diagnosticsLevel : DiagnosticsLevel.values()) {
            map.put(diagnosticsLevel.value, diagnosticsLevel);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("DiagnosticsLevel");
        builder.setJavaClass(DiagnosticsLevel.class);
        builder.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19723")));
        builder.addMapping(0, "Basic");
        builder.addMapping(1, "Advanced");
        builder.addMapping(2, "Info");
        builder.addMapping(3, "Log");
        builder.addMapping(4, "Debug");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return DiagnosticsLevel.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    implements Enumeration.Builder {
        private DiagnosticsLevel value;

        private Builder() {
        }

        @Override
        public DiagnosticsLevel build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = DiagnosticsLevel.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum DiagnosticsLevel int value: " + n2);
            }
            return this;
        }
    }
}

