/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataTypeSchemaHeader;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.FieldMetaData;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14523")
public class DataSetMetaDataType
extends DataTypeSchemaHeader {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DataSetMetaDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DataSetMetaDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DataSetMetaDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DataSetMetaDataType;
    public static final StructureSpecification SPECIFICATION;
    private String f_name;
    private LocalizedText f_description;
    private FieldMetaData[] f_fields;
    private UUID f_dataSetClassId;
    private ConfigurationVersionDataType f_configurationVersion;

    public DataSetMetaDataType() {
    }

    public DataSetMetaDataType(String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        this.f_name = string;
        this.f_description = localizedText;
        this.f_fields = fieldMetaDataArray;
        this.f_dataSetClassId = uUID;
        this.f_configurationVersion = configurationVersionDataType;
    }

    public DataSetMetaDataType(String[] stringArray, StructureDescription[] structureDescriptionArray, EnumDescription[] enumDescriptionArray, SimpleTypeDescription[] simpleTypeDescriptionArray, String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        super(stringArray, structureDescriptionArray, enumDescriptionArray, simpleTypeDescriptionArray);
        this.f_name = string;
        this.f_description = localizedText;
        this.f_fields = fieldMetaDataArray;
        this.f_dataSetClassId = uUID;
        this.f_configurationVersion = configurationVersionDataType;
    }

    public String getName() {
        return this.f_name;
    }

    public void setName(String string) {
        this.f_name = string;
    }

    public LocalizedText getDescription() {
        return this.f_description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.f_description = localizedText;
    }

    public FieldMetaData[] getFields() {
        return this.f_fields;
    }

    public void setFields(FieldMetaData[] fieldMetaDataArray) {
        this.f_fields = fieldMetaDataArray;
    }

    public UUID getDataSetClassId() {
        return this.f_dataSetClassId;
    }

    public void setDataSetClassId(UUID uUID) {
        this.f_dataSetClassId = uUID;
    }

    public ConfigurationVersionDataType getConfigurationVersion() {
        return this.f_configurationVersion;
    }

    public void setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
        this.f_configurationVersion = configurationVersionDataType;
    }

    @Override
    public DataSetMetaDataType clone() {
        DataSetMetaDataType dataSetMetaDataType = (DataSetMetaDataType)super.clone();
        dataSetMetaDataType.f_name = StructureUtils.clone(this.f_name);
        dataSetMetaDataType.f_description = StructureUtils.clone(this.f_description);
        dataSetMetaDataType.f_fields = StructureUtils.clone(this.f_fields);
        dataSetMetaDataType.f_dataSetClassId = StructureUtils.clone(this.f_dataSetClassId);
        dataSetMetaDataType.f_configurationVersion = StructureUtils.clone(this.f_configurationVersion);
        return dataSetMetaDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataSetMetaDataType dataSetMetaDataType = (DataSetMetaDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), dataSetMetaDataType.getNamespaces())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), dataSetMetaDataType.getStructureDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), dataSetMetaDataType.getEnumDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), dataSetMetaDataType.getSimpleDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), dataSetMetaDataType.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), dataSetMetaDataType.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getFields(), dataSetMetaDataType.getFields())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataSetClassId(), dataSetMetaDataType.getDataSetClassId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getConfigurationVersion(), dataSetMetaDataType.getConfigurationVersion());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getName(), this.getDescription(), this.getFields(), this.getDataSetClassId(), this.getConfigurationVersion());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_name = null;
        this.f_description = null;
        this.f_fields = null;
        this.f_dataSetClassId = null;
        this.f_configurationVersion = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Namespaces, this.getNamespaces());
        linkedHashMap.put(Fields.StructureDataTypes, this.getStructureDataTypes());
        linkedHashMap.put(Fields.EnumDataTypes, this.getEnumDataTypes());
        linkedHashMap.put(Fields.SimpleDataTypes, this.getSimpleDataTypes());
        linkedHashMap.put(Fields.Name, this.getName());
        linkedHashMap.put(Fields.Description, this.getDescription());
        linkedHashMap.put(Fields.Fields, this.getFields());
        linkedHashMap.put(Fields.DataSetClassId, this.getDataSetClassId());
        linkedHashMap.put(Fields.ConfigurationVersion, this.getConfigurationVersion());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Namespaces.equals(fieldSpecification)) {
            return this.getNamespaces();
        }
        if (Fields.StructureDataTypes.equals(fieldSpecification)) {
            return this.getStructureDataTypes();
        }
        if (Fields.EnumDataTypes.equals(fieldSpecification)) {
            return this.getEnumDataTypes();
        }
        if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
            return this.getSimpleDataTypes();
        }
        if (Fields.Name.equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.Description.equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.Fields.equals(fieldSpecification)) {
            return this.getFields();
        }
        if (Fields.DataSetClassId.equals(fieldSpecification)) {
            return this.getDataSetClassId();
        }
        if (Fields.ConfigurationVersion.equals(fieldSpecification)) {
            return this.getConfigurationVersion();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Namespaces.equals(fieldSpecification)) {
            this.setNamespaces((String[])object);
            return;
        }
        if (Fields.StructureDataTypes.equals(fieldSpecification)) {
            this.setStructureDataTypes((StructureDescription[])object);
            return;
        }
        if (Fields.EnumDataTypes.equals(fieldSpecification)) {
            this.setEnumDataTypes((EnumDescription[])object);
            return;
        }
        if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
            this.setSimpleDataTypes((SimpleTypeDescription[])object);
            return;
        }
        if (Fields.Name.equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.Description.equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.Fields.equals(fieldSpecification)) {
            this.setFields((FieldMetaData[])object);
            return;
        }
        if (Fields.DataSetClassId.equals(fieldSpecification)) {
            this.setDataSetClassId((UUID)object);
            return;
        }
        if (Fields.ConfigurationVersion.equals(fieldSpecification)) {
            this.setConfigurationVersion((ConfigurationVersionDataType)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DataSetMetaDataType.builder();
        builder.setNamespaces(StructureUtils.clone(this.getNamespaces()));
        builder.setStructureDataTypes(StructureUtils.clone(this.getStructureDataTypes()));
        builder.setEnumDataTypes(StructureUtils.clone(this.getEnumDataTypes()));
        builder.setSimpleDataTypes(StructureUtils.clone(this.getSimpleDataTypes()));
        builder.setName(StructureUtils.clone(this.getName()));
        builder.setDescription(StructureUtils.clone(this.getDescription()));
        builder.setFields(StructureUtils.clone(this.getFields()));
        builder.setDataSetClassId(StructureUtils.clone(this.getDataSetClassId()));
        builder.setConfigurationVersion(StructureUtils.clone(this.getConfigurationVersion()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Namespaces);
        builder.addField(Fields.StructureDataTypes);
        builder.addField(Fields.EnumDataTypes);
        builder.addField(Fields.SimpleDataTypes);
        builder.addField(Fields.Name);
        builder.addField(Fields.Description);
        builder.addField(Fields.Fields);
        builder.addField(Fields.DataSetClassId);
        builder.addField(Fields.ConfigurationVersion);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.DataTypeSchemaHeader);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("DataSetMetaDataType");
        builder.setJavaClass(DataSetMetaDataType.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeSchemaHeader.Builder {
        private String[] f_namespaces;
        private StructureDescription[] f_structureDataTypes;
        private EnumDescription[] f_enumDataTypes;
        private SimpleTypeDescription[] f_simpleDataTypes;
        private String f_name;
        private LocalizedText f_description;
        private FieldMetaData[] f_fields;
        private UUID f_dataSetClassId;
        private ConfigurationVersionDataType f_configurationVersion;

        protected Builder() {
        }

        @Override
        public String[] getNamespaces() {
            return this.f_namespaces;
        }

        @Override
        public Builder setNamespaces(String[] stringArray) {
            this.f_namespaces = stringArray;
            return this;
        }

        @Override
        public StructureDescription[] getStructureDataTypes() {
            return this.f_structureDataTypes;
        }

        @Override
        public Builder setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
            this.f_structureDataTypes = structureDescriptionArray;
            return this;
        }

        @Override
        public EnumDescription[] getEnumDataTypes() {
            return this.f_enumDataTypes;
        }

        @Override
        public Builder setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
            this.f_enumDataTypes = enumDescriptionArray;
            return this;
        }

        @Override
        public SimpleTypeDescription[] getSimpleDataTypes() {
            return this.f_simpleDataTypes;
        }

        @Override
        public Builder setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
            this.f_simpleDataTypes = simpleTypeDescriptionArray;
            return this;
        }

        public String getName() {
            return this.f_name;
        }

        public Builder setName(String string) {
            this.f_name = string;
            return this;
        }

        public LocalizedText getDescription() {
            return this.f_description;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.f_description = localizedText;
            return this;
        }

        public FieldMetaData[] getFields() {
            return this.f_fields;
        }

        public Builder setFields(FieldMetaData[] fieldMetaDataArray) {
            this.f_fields = fieldMetaDataArray;
            return this;
        }

        public UUID getDataSetClassId() {
            return this.f_dataSetClassId;
        }

        public Builder setDataSetClassId(UUID uUID) {
            this.f_dataSetClassId = uUID;
            return this;
        }

        public ConfigurationVersionDataType getConfigurationVersion() {
            return this.f_configurationVersion;
        }

        public Builder setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
            this.f_configurationVersion = configurationVersionDataType;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), builder.getNamespaces())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), builder.getStructureDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), builder.getEnumDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), builder.getSimpleDataTypes())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getName(), builder.getName())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), builder.getDescription())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getFields(), builder.getFields())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getDataSetClassId(), builder.getDataSetClassId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getConfigurationVersion(), builder.getConfigurationVersion());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getName(), this.getDescription(), this.getFields(), this.getDataSetClassId(), this.getConfigurationVersion());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Namespaces.equals(fieldSpecification)) {
                return this.getNamespaces();
            }
            if (Fields.StructureDataTypes.equals(fieldSpecification)) {
                return this.getStructureDataTypes();
            }
            if (Fields.EnumDataTypes.equals(fieldSpecification)) {
                return this.getEnumDataTypes();
            }
            if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
                return this.getSimpleDataTypes();
            }
            if (Fields.Name.equals(fieldSpecification)) {
                return this.getName();
            }
            if (Fields.Description.equals(fieldSpecification)) {
                return this.getDescription();
            }
            if (Fields.Fields.equals(fieldSpecification)) {
                return this.getFields();
            }
            if (Fields.DataSetClassId.equals(fieldSpecification)) {
                return this.getDataSetClassId();
            }
            if (Fields.ConfigurationVersion.equals(fieldSpecification)) {
                return this.getConfigurationVersion();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Namespaces.equals(fieldSpecification)) {
                this.setNamespaces((String[])object);
                return this;
            }
            if (Fields.StructureDataTypes.equals(fieldSpecification)) {
                this.setStructureDataTypes((StructureDescription[])object);
                return this;
            }
            if (Fields.EnumDataTypes.equals(fieldSpecification)) {
                this.setEnumDataTypes((EnumDescription[])object);
                return this;
            }
            if (Fields.SimpleDataTypes.equals(fieldSpecification)) {
                this.setSimpleDataTypes((SimpleTypeDescription[])object);
                return this;
            }
            if (Fields.Name.equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.Description.equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.Fields.equals(fieldSpecification)) {
                this.setFields((FieldMetaData[])object);
                return this;
            }
            if (Fields.DataSetClassId.equals(fieldSpecification)) {
                this.setDataSetClassId((UUID)object);
                return this;
            }
            if (Fields.ConfigurationVersion.equals(fieldSpecification)) {
                this.setConfigurationVersion((ConfigurationVersionDataType)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_name = null;
            this.f_description = null;
            this.f_fields = null;
            this.f_dataSetClassId = null;
            this.f_configurationVersion = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public DataSetMetaDataType build() {
            return new DataSetMetaDataType(this.f_namespaces, this.f_structureDataTypes, this.f_enumDataTypes, this.f_simpleDataTypes, this.f_name, this.f_description, this.f_fields, this.f_dataSetClassId, this.f_configurationVersion);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Namespaces("Namespaces", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false),
        StructureDataTypes("StructureDataTypes", StructureDescription[].class, false, UaIds.StructureDescription, 1, UaArrayDimensions.valueOf(0L), false),
        EnumDataTypes("EnumDataTypes", EnumDescription[].class, false, UaIds.EnumDescription, 1, UaArrayDimensions.valueOf(0L), false),
        SimpleDataTypes("SimpleDataTypes", SimpleTypeDescription[].class, false, UaIds.SimpleTypeDescription, 1, UaArrayDimensions.valueOf(0L), false),
        Name("Name", String.class, false, UaIds.String, -1, null, false),
        Description("Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false),
        Fields("Fields", FieldMetaData[].class, false, UaIds.FieldMetaData, 1, UaArrayDimensions.valueOf(0L), false),
        DataSetClassId("DataSetClassId", UUID.class, false, UaIds.Guid, -1, null, false),
        ConfigurationVersion("ConfigurationVersion", ConfigurationVersionDataType.class, false, UaIds.ConfigurationVersionDataType, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

