/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=522")
public class BrowseResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowseResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowseResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowseResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowseResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode f_statusCode;
    private ByteString f_continuationPoint;
    private ReferenceDescription[] f_references;

    public BrowseResult() {
    }

    public BrowseResult(StatusCode statusCode, ByteString byteString, ReferenceDescription[] referenceDescriptionArray) {
        this.f_statusCode = statusCode;
        this.f_continuationPoint = byteString;
        this.f_references = referenceDescriptionArray;
    }

    public StatusCode getStatusCode() {
        return this.f_statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.f_statusCode = statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.f_continuationPoint;
    }

    public void setContinuationPoint(ByteString byteString) {
        this.f_continuationPoint = byteString;
    }

    public ReferenceDescription[] getReferences() {
        return this.f_references;
    }

    public void setReferences(ReferenceDescription[] referenceDescriptionArray) {
        this.f_references = referenceDescriptionArray;
    }

    @Override
    public BrowseResult clone() {
        BrowseResult browseResult = (BrowseResult)super.clone();
        browseResult.f_statusCode = StructureUtils.clone(this.f_statusCode);
        browseResult.f_continuationPoint = StructureUtils.clone(this.f_continuationPoint);
        browseResult.f_references = StructureUtils.clone(this.f_references);
        return browseResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseResult browseResult = (BrowseResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), browseResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), browseResult.getContinuationPoint())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getReferences(), browseResult.getReferences());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getContinuationPoint(), this.getReferences());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_statusCode = null;
        this.f_continuationPoint = null;
        this.f_references = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.StatusCode, this.getStatusCode());
        linkedHashMap.put(Fields.ContinuationPoint, this.getContinuationPoint());
        linkedHashMap.put(Fields.References, this.getReferences());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.ContinuationPoint.equals(fieldSpecification)) {
            return this.getContinuationPoint();
        }
        if (Fields.References.equals(fieldSpecification)) {
            return this.getReferences();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.ContinuationPoint.equals(fieldSpecification)) {
            this.setContinuationPoint((ByteString)object);
            return;
        }
        if (Fields.References.equals(fieldSpecification)) {
            this.setReferences((ReferenceDescription[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowseResult.builder();
        builder.setStatusCode(StructureUtils.clone(this.getStatusCode()));
        builder.setContinuationPoint(StructureUtils.clone(this.getContinuationPoint()));
        builder.setReferences(StructureUtils.clone(this.getReferences()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode);
        builder.addField(Fields.ContinuationPoint);
        builder.addField(Fields.References);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("BrowseResult");
        builder.setJavaClass(BrowseResult.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode f_statusCode;
        private ByteString f_continuationPoint;
        private ReferenceDescription[] f_references;

        protected Builder() {
        }

        public StatusCode getStatusCode() {
            return this.f_statusCode;
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.f_statusCode = statusCode;
            return this;
        }

        public ByteString getContinuationPoint() {
            return this.f_continuationPoint;
        }

        public Builder setContinuationPoint(ByteString byteString) {
            this.f_continuationPoint = byteString;
            return this;
        }

        public ReferenceDescription[] getReferences() {
            return this.f_references;
        }

        public Builder setReferences(ReferenceDescription[] referenceDescriptionArray) {
            this.f_references = referenceDescriptionArray;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), builder.getStatusCode())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), builder.getContinuationPoint())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getReferences(), builder.getReferences());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getStatusCode(), this.getContinuationPoint(), this.getReferences());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.StatusCode.equals(fieldSpecification)) {
                return this.getStatusCode();
            }
            if (Fields.ContinuationPoint.equals(fieldSpecification)) {
                return this.getContinuationPoint();
            }
            if (Fields.References.equals(fieldSpecification)) {
                return this.getReferences();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.ContinuationPoint.equals(fieldSpecification)) {
                this.setContinuationPoint((ByteString)object);
                return this;
            }
            if (Fields.References.equals(fieldSpecification)) {
                this.setReferences((ReferenceDescription[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_statusCode = null;
            this.f_continuationPoint = null;
            this.f_references = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public BrowseResult build() {
            return new BrowseResult(this.f_statusCode, this.f_continuationPoint, this.f_references);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StatusCode("StatusCode", StatusCode.class, false, UaIds.StatusCode, -1, null, false),
        ContinuationPoint("ContinuationPoint", ByteString.class, false, UaIds.ContinuationPoint, -1, null, false),
        References("References", ReferenceDescription[].class, false, UaIds.ReferenceDescription, 1, UaArrayDimensions.valueOf(0L), false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

