/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=546")
public class BrowsePathTarget
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowsePathTarget_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowsePathTarget_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowsePathTarget_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowsePathTarget;
    public static final StructureSpecification SPECIFICATION;
    private ExpandedNodeId f_targetId;
    private UnsignedInteger f_remainingPathIndex;

    public BrowsePathTarget() {
    }

    public BrowsePathTarget(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) {
        this.f_targetId = expandedNodeId;
        this.f_remainingPathIndex = unsignedInteger;
    }

    public ExpandedNodeId getTargetId() {
        return this.f_targetId;
    }

    public void setTargetId(ExpandedNodeId expandedNodeId) {
        this.f_targetId = expandedNodeId;
    }

    public UnsignedInteger getRemainingPathIndex() {
        return this.f_remainingPathIndex;
    }

    public void setRemainingPathIndex(UnsignedInteger unsignedInteger) {
        this.f_remainingPathIndex = unsignedInteger;
    }

    @Override
    public BrowsePathTarget clone() {
        BrowsePathTarget browsePathTarget = (BrowsePathTarget)super.clone();
        browsePathTarget.f_targetId = StructureUtils.clone(this.f_targetId);
        browsePathTarget.f_remainingPathIndex = StructureUtils.clone(this.f_remainingPathIndex);
        return browsePathTarget;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePathTarget browsePathTarget = (BrowsePathTarget)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTargetId(), browsePathTarget.getTargetId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRemainingPathIndex(), browsePathTarget.getRemainingPathIndex());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getTargetId(), this.getRemainingPathIndex());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_targetId = null;
        this.f_remainingPathIndex = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Comparable<ExpandedNodeId>> linkedHashMap = new LinkedHashMap<Fields, Comparable<ExpandedNodeId>>();
        linkedHashMap.put(Fields.TargetId, this.getTargetId());
        linkedHashMap.put(Fields.RemainingPathIndex, this.getRemainingPathIndex());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.TargetId.equals(fieldSpecification)) {
            return this.getTargetId();
        }
        if (Fields.RemainingPathIndex.equals(fieldSpecification)) {
            return this.getRemainingPathIndex();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.TargetId.equals(fieldSpecification)) {
            this.setTargetId((ExpandedNodeId)object);
            return;
        }
        if (Fields.RemainingPathIndex.equals(fieldSpecification)) {
            this.setRemainingPathIndex((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowsePathTarget.builder();
        builder.setTargetId(StructureUtils.clone(this.getTargetId()));
        builder.setRemainingPathIndex(StructureUtils.clone(this.getRemainingPathIndex()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.TargetId);
        builder.addField(Fields.RemainingPathIndex);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("BrowsePathTarget");
        builder.setJavaClass(BrowsePathTarget.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ExpandedNodeId f_targetId;
        private UnsignedInteger f_remainingPathIndex;

        protected Builder() {
        }

        public ExpandedNodeId getTargetId() {
            return this.f_targetId;
        }

        public Builder setTargetId(ExpandedNodeId expandedNodeId) {
            this.f_targetId = expandedNodeId;
            return this;
        }

        public UnsignedInteger getRemainingPathIndex() {
            return this.f_remainingPathIndex;
        }

        public Builder setRemainingPathIndex(UnsignedInteger unsignedInteger) {
            this.f_remainingPathIndex = unsignedInteger;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getTargetId(), builder.getTargetId())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getRemainingPathIndex(), builder.getRemainingPathIndex());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getTargetId(), this.getRemainingPathIndex());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.TargetId.equals(fieldSpecification)) {
                return this.getTargetId();
            }
            if (Fields.RemainingPathIndex.equals(fieldSpecification)) {
                return this.getRemainingPathIndex();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.TargetId.equals(fieldSpecification)) {
                this.setTargetId((ExpandedNodeId)object);
                return this;
            }
            if (Fields.RemainingPathIndex.equals(fieldSpecification)) {
                this.setRemainingPathIndex((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_targetId = null;
            this.f_remainingPathIndex = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public BrowsePathTarget build() {
            return new BrowsePathTarget(this.f_targetId, this.f_remainingPathIndex);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        TargetId("TargetId", ExpandedNodeId.class, false, UaIds.ExpandedNodeId, -1, null, false),
        RemainingPathIndex("RemainingPathIndex", UnsignedInteger.class, false, UaIds.Index, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

