/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=543")
public class BrowsePath
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowsePath_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowsePath_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowsePath_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowsePath;
    public static final StructureSpecification SPECIFICATION;
    private NodeId f_startingNode;
    private RelativePath f_relativePath;

    public BrowsePath() {
    }

    public BrowsePath(NodeId nodeId, RelativePath relativePath) {
        this.f_startingNode = nodeId;
        this.f_relativePath = relativePath;
    }

    public NodeId getStartingNode() {
        return this.f_startingNode;
    }

    public void setStartingNode(NodeId nodeId) {
        this.f_startingNode = nodeId;
    }

    public RelativePath getRelativePath() {
        return this.f_relativePath;
    }

    public void setRelativePath(RelativePath relativePath) {
        this.f_relativePath = relativePath;
    }

    @Override
    public BrowsePath clone() {
        BrowsePath browsePath = (BrowsePath)super.clone();
        browsePath.f_startingNode = StructureUtils.clone(this.f_startingNode);
        browsePath.f_relativePath = StructureUtils.clone(this.f_relativePath);
        return browsePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePath browsePath = (BrowsePath)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartingNode(), browsePath.getStartingNode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRelativePath(), browsePath.getRelativePath());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStartingNode(), this.getRelativePath());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_startingNode = null;
        this.f_relativePath = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, UaNamespaceTranslateable<NodeId>> linkedHashMap = new LinkedHashMap<Fields, UaNamespaceTranslateable<NodeId>>();
        linkedHashMap.put(Fields.StartingNode, this.getStartingNode());
        linkedHashMap.put(Fields.RelativePath, this.getRelativePath());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartingNode.equals(fieldSpecification)) {
            return this.getStartingNode();
        }
        if (Fields.RelativePath.equals(fieldSpecification)) {
            return this.getRelativePath();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartingNode.equals(fieldSpecification)) {
            this.setStartingNode((NodeId)object);
            return;
        }
        if (Fields.RelativePath.equals(fieldSpecification)) {
            this.setRelativePath((RelativePath)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowsePath.builder();
        builder.setStartingNode(StructureUtils.clone(this.getStartingNode()));
        builder.setRelativePath(StructureUtils.clone(this.getRelativePath()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StartingNode);
        builder.addField(Fields.RelativePath);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("BrowsePath");
        builder.setJavaClass(BrowsePath.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId f_startingNode;
        private RelativePath f_relativePath;

        protected Builder() {
        }

        public NodeId getStartingNode() {
            return this.f_startingNode;
        }

        public Builder setStartingNode(NodeId nodeId) {
            this.f_startingNode = nodeId;
            return this;
        }

        public RelativePath getRelativePath() {
            return this.f_relativePath;
        }

        public Builder setRelativePath(RelativePath relativePath) {
            this.f_relativePath = relativePath;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getStartingNode(), builder.getStartingNode())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getRelativePath(), builder.getRelativePath());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getStartingNode(), this.getRelativePath());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.StartingNode.equals(fieldSpecification)) {
                return this.getStartingNode();
            }
            if (Fields.RelativePath.equals(fieldSpecification)) {
                return this.getRelativePath();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartingNode.equals(fieldSpecification)) {
                this.setStartingNode((NodeId)object);
                return this;
            }
            if (Fields.RelativePath.equals(fieldSpecification)) {
                this.setRelativePath((RelativePath)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_startingNode = null;
            this.f_relativePath = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public BrowsePath build() {
            return new BrowsePath(this.f_startingNode, this.f_relativePath);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StartingNode("StartingNode", NodeId.class, false, UaIds.NodeId, -1, null, false),
        RelativePath("RelativePath", RelativePath.class, false, UaIds.RelativePath, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

