/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=319")
public class AnonymousIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AnonymousIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AnonymousIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AnonymousIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AnonymousIdentityToken;
    public static final StructureSpecification SPECIFICATION;

    public AnonymousIdentityToken() {
    }

    public AnonymousIdentityToken(String string) {
        super(string);
    }

    @Override
    public AnonymousIdentityToken clone() {
        AnonymousIdentityToken anonymousIdentityToken = (AnonymousIdentityToken)super.clone();
        return anonymousIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AnonymousIdentityToken anonymousIdentityToken = (AnonymousIdentityToken)object;
        return StructureUtils.scalarOrArrayEquals(this.getPolicyId(), anonymousIdentityToken.getPolicyId());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId());
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, String> linkedHashMap = new LinkedHashMap<Fields, String>();
        linkedHashMap.put(Fields.PolicyId, this.getPolicyId());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AnonymousIdentityToken.builder();
        builder.setPolicyId(StructureUtils.clone(this.getPolicyId()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.UserIdentityToken);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("AnonymousIdentityToken");
        builder.setJavaClass(AnonymousIdentityToken.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String f_policyId;

        protected Builder() {
        }

        @Override
        public String getPolicyId() {
            return this.f_policyId;
        }

        @Override
        public Builder setPolicyId(String string) {
            this.f_policyId = string;
            return this;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            return StructureUtils.scalarOrArrayEquals(this.getPolicyId(), builder.getPolicyId());
        }

        @Override
        public int hashCode() {
            return StructureUtils.hashCode(this.getPolicyId());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                return this.getPolicyId();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public AnonymousIdentityToken build() {
            return new AnonymousIdentityToken(this.f_policyId);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        PolicyId("PolicyId", String.class, false, UaIds.String, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

