/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=891")
public class Annotation
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.Annotation_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.Annotation_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.Annotation_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.Annotation;
    public static final StructureSpecification SPECIFICATION;
    private String f_message;
    private String f_userName;
    private DateTime f_annotationTime;

    public Annotation() {
    }

    public Annotation(String string, String string2, DateTime dateTime) {
        this.f_message = string;
        this.f_userName = string2;
        this.f_annotationTime = dateTime;
    }

    public String getMessage() {
        return this.f_message;
    }

    public void setMessage(String string) {
        this.f_message = string;
    }

    public String getUserName() {
        return this.f_userName;
    }

    public void setUserName(String string) {
        this.f_userName = string;
    }

    public DateTime getAnnotationTime() {
        return this.f_annotationTime;
    }

    public void setAnnotationTime(DateTime dateTime) {
        this.f_annotationTime = dateTime;
    }

    @Override
    public Annotation clone() {
        Annotation annotation = (Annotation)super.clone();
        annotation.f_message = StructureUtils.clone(this.f_message);
        annotation.f_userName = StructureUtils.clone(this.f_userName);
        annotation.f_annotationTime = StructureUtils.clone(this.f_annotationTime);
        return annotation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMessage(), annotation.getMessage())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), annotation.getUserName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAnnotationTime(), annotation.getAnnotationTime());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getMessage(), this.getUserName(), this.getAnnotationTime());
    }

    @Override
    public void clear() {
        super.clear();
        this.f_message = null;
        this.f_userName = null;
        this.f_annotationTime = null;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        LinkedHashMap<Fields, Object> linkedHashMap = new LinkedHashMap<Fields, Object>();
        linkedHashMap.put(Fields.Message, this.getMessage());
        linkedHashMap.put(Fields.UserName, this.getUserName());
        linkedHashMap.put(Fields.AnnotationTime, this.getAnnotationTime());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Message.equals(fieldSpecification)) {
            return this.getMessage();
        }
        if (Fields.UserName.equals(fieldSpecification)) {
            return this.getUserName();
        }
        if (Fields.AnnotationTime.equals(fieldSpecification)) {
            return this.getAnnotationTime();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Message.equals(fieldSpecification)) {
            this.setMessage((String)object);
            return;
        }
        if (Fields.UserName.equals(fieldSpecification)) {
            this.setUserName((String)object);
            return;
        }
        if (Fields.AnnotationTime.equals(fieldSpecification)) {
            this.setAnnotationTime((DateTime)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Annotation.builder();
        builder.setMessage(StructureUtils.clone(this.getMessage()));
        builder.setUserName(StructureUtils.clone(this.getUserName()));
        builder.setAnnotationTime(StructureUtils.clone(this.getAnnotationTime()));
        return builder;
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Message);
        builder.addField(Fields.UserName);
        builder.addField(Fields.AnnotationTime);
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("Annotation");
        builder.setJavaClass(Annotation.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(Builder::new);
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String f_message;
        private String f_userName;
        private DateTime f_annotationTime;

        protected Builder() {
        }

        public String getMessage() {
            return this.f_message;
        }

        public Builder setMessage(String string) {
            this.f_message = string;
            return this;
        }

        public String getUserName() {
            return this.f_userName;
        }

        public Builder setUserName(String string) {
            this.f_userName = string;
            return this;
        }

        public DateTime getAnnotationTime() {
            return this.f_annotationTime;
        }

        public Builder setAnnotationTime(DateTime dateTime) {
            this.f_annotationTime = dateTime;
            return this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!StructureUtils.scalarOrArrayEquals(this.getMessage(), builder.getMessage())) {
                return false;
            }
            if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), builder.getUserName())) {
                return false;
            }
            return StructureUtils.scalarOrArrayEquals(this.getAnnotationTime(), builder.getAnnotationTime());
        }

        public int hashCode() {
            return StructureUtils.hashCode(this.getMessage(), this.getUserName(), this.getAnnotationTime());
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            if (Fields.Message.equals(fieldSpecification)) {
                return this.getMessage();
            }
            if (Fields.UserName.equals(fieldSpecification)) {
                return this.getUserName();
            }
            if (Fields.AnnotationTime.equals(fieldSpecification)) {
                return this.getAnnotationTime();
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Message.equals(fieldSpecification)) {
                this.setMessage((String)object);
                return this;
            }
            if (Fields.UserName.equals(fieldSpecification)) {
                this.setUserName((String)object);
                return this;
            }
            if (Fields.AnnotationTime.equals(fieldSpecification)) {
                this.setAnnotationTime((DateTime)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder clear() {
            super.clear();
            this.f_message = null;
            this.f_userName = null;
            this.f_annotationTime = null;
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return SPECIFICATION;
        }

        @Override
        public Annotation build() {
            return new Annotation(this.f_message, this.f_userName, this.f_annotationTime);
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Message("Message", String.class, false, UaIds.String, -1, null, false),
        UserName("UserName", String.class, false, UaIds.String, -1, null, false),
        AnnotationTime("AnnotationTime", DateTime.class, false, UaIds.UtcTime, -1, null, false);

        private final FieldSpecification delegate;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3, UaArrayDimensions uaArrayDimensions, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            builder.setArrayDimensions(uaArrayDimensions);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Deprecated
        public FieldSpecification getSpecification() {
            return this;
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }
}

