/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.common;

import com.prosysopc.ua.stack.utils.BijectionMap;
import java.util.Arrays;
import java.util.function.Function;

public class UriTable<T> {
    private final BijectionMap<Integer, String> sI = new BijectionMap();
    private final BijectionMap<Integer, T> sJ = new BijectionMap();
    private final BijectionMap<String, T> sK = new BijectionMap();
    private final Function<String, T> sL;

    public UriTable(Function<String, T> function) {
        this.sL = function;
    }

    public synchronized int add(int n2, String string) {
        int n3 = this.getIndex(string);
        if (n3 >= 0) {
            return n3;
        }
        if (n2 < 0) {
            n2 = this.nextIndex();
        } else if (this.getUri(n2) != null) {
            throw new IllegalArgumentException("namespaceTable already has namespaceIndex " + n2);
        }
        this.sI.map(n2, string);
        T t = this.sL.apply(string);
        if (t != null) {
            this.sJ.map(n2, t);
            this.sK.map(string, t);
        }
        return n2;
    }

    public synchronized int add(String string) {
        return this.add(-1, string);
    }

    public synchronized void addAll(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.add(i2, stringArray[i2]);
        }
    }

    public int getIndex(String string) {
        Integer n2 = this.sI.getLeft(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public String getUri(int n2) {
        return this.sI.getRight(n2);
    }

    public synchronized void remove(int n2) {
        this.sI.removeWithLeft(n2);
        T t = this.sJ.removeWithLeft(n2);
        this.sK.removeWithRight(t);
    }

    public synchronized void remove(String string) {
        this.sI.removeWithRight(string);
        T t = this.sK.removeWithLeft(string);
        this.sJ.removeWithRight(t);
    }

    public int size() {
        return this.sI.size();
    }

    public synchronized String[] toArray() {
        int n2 = 0;
        for (Integer n3 : this.sI.getLeftSet()) {
            if (n3 <= n2) continue;
            n2 = n3;
        }
        String[] stringArray = new String[++n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = this.sI.getRight(i2);
        }
        return stringArray;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private int nextIndex() {
        int n2 = -1;
        for (int n3 : this.sI.getLeftSet()) {
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 + 1;
    }

    protected T getObjectByIndex(int n2) {
        return this.sJ.getRight(n2);
    }

    protected T getObjectByUri(String string) {
        return this.sK.getRight(string);
    }
}

