/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class XmlElement
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(XmlElement.class);
    @Deprecated
    public static final NodeId ID = Identifiers.XmlElement;
    public static final XmlElement[] EMPTY_ARRAY = new XmlElement[0];
    public static final String UTF8_BOM = "\ufeff";
    private final String document;

    static String a(Node node, boolean bl, int n2) {
        Transformer transformer = null;
        try {
            transformer = XMLFactoryCache.getTransformerFactory().newTransformer();
            if (n2 < 1) {
                transformer.setOutputProperty("indent", "no");
            } else {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", "no");
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "utf-8");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Unexpected failure when creating Transformer", transformerConfigurationException);
        }
        StringWriter stringWriter = new StringWriter();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException("Unexpected failure when transforming XML to String", transformerException);
        }
        return stringWriter.toString();
    }

    static Node B(String string) throws IllegalStateException {
        try {
            StringReader stringReader = new StringReader(string);
            char[] cArray = new char[2];
            stringReader.read(cArray, 0, 1);
            if (cArray[0] != UTF8_BOM.charAt(0)) {
                stringReader = new StringReader(string);
            }
            DocumentBuilder documentBuilder = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder();
            return documentBuilder.parse(new InputSource(stringReader));
        }
        catch (Exception exception) {
            throw new IllegalStateException("The XmlElement data is not a valid XML document", exception);
        }
    }

    static String a(String string, boolean bl, int n2) {
        try {
            return XmlElement.a(XmlElement.B(string), bl, n2);
        }
        catch (Exception exception) {
            logger.trace("Cannot convert {} as pretty xml", (Object)string, (Object)exception);
            return string;
        }
    }

    public XmlElement(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.document = byArray.length == 0 ? "" : new String(byArray, StandardCharsets.UTF_8);
    }

    public XmlElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.document = XmlElement.a(node, false, 0);
    }

    public XmlElement(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.document = string;
    }

    public XmlElement clone() {
        try {
            return (XmlElement)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Every XmlElement implementation shall be Cloneable", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof XmlElement)) {
            return false;
        }
        XmlElement xmlElement = (XmlElement)object;
        return Objects.equals(this.document, xmlElement.document);
    }

    public synchronized byte[] getData() {
        return this.document.getBytes(StandardCharsets.UTF_8);
    }

    public synchronized Node getNode() throws IllegalStateException {
        return XmlElement.B(this.document);
    }

    public synchronized String getValue() {
        return this.document;
    }

    public int hashCode() {
        return Objects.hash(this.document);
    }

    public String toPrettyString(boolean bl, int n2) {
        try {
            return XmlElement.a(XmlElement.B(this.document), bl, n2);
        }
        catch (Exception exception) {
            return this.document;
        }
    }

    public String toString() {
        return this.getValue();
    }
}

