/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import java.math.BigInteger;

public final class UnsignedLong
extends Number
implements BitField,
Comparable<Number> {
    private static final UnsignedLong[] CACHE = new UnsignedLong[1024];
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final NodeId ID = Identifiers.UInt64;
    public static final int SIZE = 64;
    private static final long L_MAX_VALUE = Long.MAX_VALUE;
    private static final long L_HI_BIT = Long.MIN_VALUE;
    private static final BigInteger BI_L_MAX_VALUE = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger BI_MAX_VALUE = new BigInteger("2").pow(64).add(new BigInteger("-1"));
    private static final BigInteger BI_MIN_VALUE = new BigInteger("0");
    private static final BigInteger BI_MID_VALUE = new BigInteger("2").pow(63);
    private static final double D_MID_VALUE = BI_MID_VALUE.doubleValue();
    private static final float F_MID_VALUE = BI_MID_VALUE.floatValue();
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(BI_MAX_VALUE);
    public static final UnsignedLong MIN_VALUE;
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    public static final UnsignedLong[] EMPTY_ARRAY;
    private long value;

    public static UnsignedLong[] arrayOf() {
        return EMPTY_ARRAY;
    }

    public static UnsignedLong[] arrayOf(BigInteger ... bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        if (bigIntegerArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedLong[] unsignedLongArray = new UnsignedLong[bigIntegerArray.length];
        for (int i2 = 0; i2 < bigIntegerArray.length; ++i2) {
            unsignedLongArray[i2] = UnsignedLong.valueOf(bigIntegerArray[i2]);
        }
        return unsignedLongArray;
    }

    public static UnsignedLong[] arrayOf(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedLong[] unsignedLongArray = new UnsignedLong[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            unsignedLongArray[i2] = UnsignedLong.valueOf(lArray[i2]);
        }
        return unsignedLongArray;
    }

    public static UnsignedLong[] arrayOf(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedLong[] unsignedLongArray = new UnsignedLong[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            unsignedLongArray[i2] = UnsignedLong.valueOf(stringArray[i2]);
        }
        return unsignedLongArray;
    }

    public static UnsignedLong getFromBits(long l2) {
        if (l2 >= 0L && l2 < (long)CACHE.length) {
            return CACHE[(int)l2];
        }
        UnsignedLong unsignedLong = new UnsignedLong(0);
        unsignedLong.value = l2;
        return unsignedLong;
    }

    public static UnsignedLong parseUnsignedLong(String string) {
        return new UnsignedLong(new BigInteger(string));
    }

    public static UnsignedLong parseUnsignedLong(String string, int n2) throws NumberFormatException, IllegalArgumentException {
        return new UnsignedLong(new BigInteger(string, n2));
    }

    public static UnsignedLong valueOf(BigInteger bigInteger) {
        return new UnsignedLong(bigInteger);
    }

    public static UnsignedLong valueOf(long l2) {
        if (l2 >= 0L && l2 < (long)CACHE.length) {
            return CACHE[(int)l2];
        }
        return new UnsignedLong(l2);
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.parseUnsignedLong(string);
    }

    public static UnsignedLong valueOf(String string, int n2) {
        return UnsignedLong.parseUnsignedLong(string, n2);
    }

    @Deprecated
    public UnsignedLong(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger.compareTo(BI_MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        if (bigInteger.compareTo(BI_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = bigInteger.compareTo(BI_L_MAX_VALUE) <= 0 ? bigInteger.longValue() : bigInteger.subtract(BI_MID_VALUE).longValue() | Long.MIN_VALUE;
    }

    @Deprecated
    public UnsignedLong(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = n2;
    }

    @Deprecated
    public UnsignedLong(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = l2;
    }

    @Deprecated
    public UnsignedLong(String string) {
        BigInteger bigInteger = new BigInteger(string);
        if (bigInteger.compareTo(BI_MIN_VALUE) < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        if (bigInteger.compareTo(BI_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Value overflow");
        }
        this.value = bigInteger.compareTo(BI_L_MAX_VALUE) < 0 ? bigInteger.longValue() : bigInteger.subtract(BI_MID_VALUE).longValue() | Long.MIN_VALUE;
    }

    public UnsignedLong add(long l2) {
        long l3 = this.getValue() + l2;
        if (l2 > 0L && (this.getValue() < 0L || l3 < this.getValue())) {
            return new UnsignedLong(this.bigIntegerValue().add(BigInteger.valueOf(l2)));
        }
        return UnsignedLong.valueOf(l3);
    }

    public UnsignedLong add(UnsignedLong unsignedLong) {
        long l2 = this.getValue() + unsignedLong.getValue();
        if (unsignedLong.getValue() > 0L && l2 < this.getValue()) {
            return new UnsignedLong(BigInteger.valueOf(this.getValue()).add(BigInteger.valueOf(unsignedLong.getValue())));
        }
        return UnsignedLong.valueOf(l2);
    }

    public BigInteger bigIntegerValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return BigInteger.valueOf(this.value & Long.MAX_VALUE).add(BI_MID_VALUE);
        }
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int compareTo(Number number) {
        long l2;
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE ^ (number.longValue() & Long.MIN_VALUE) == Long.MIN_VALUE) {
            if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
                return 1;
            }
            return -1;
        }
        long l3 = this.longValue();
        return l3 < (l2 = number.longValue()) ? -1 : (l3 == l2 ? 0 : 1);
    }

    public UnsignedLong dec() {
        return UnsignedLong.valueOf(this.getValue() - 1L);
    }

    public UnsignedLong decOrWrap() {
        if (this.equals(MIN_VALUE)) {
            return MAX_VALUE;
        }
        return this.dec();
    }

    public UnsignedLong decOrWrapTo(UnsignedLong unsignedLong) {
        if (this.equals(MIN_VALUE)) {
            return unsignedLong;
        }
        return this.dec();
    }

    @Override
    public double doubleValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (double)(this.value & Long.MAX_VALUE) + D_MID_VALUE;
        }
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedLong.class)) {
            return false;
        }
        UnsignedLong unsignedLong = (UnsignedLong)object;
        return this.value == unsignedLong.value;
    }

    @Override
    public float floatValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (float)(this.value & Long.MAX_VALUE) + F_MID_VALUE;
        }
        return this.value;
    }

    public int hashCode() {
        return (int)this.value | (int)(this.value >> 32);
    }

    public UnsignedLong inc() {
        return UnsignedLong.valueOf(this.getValue() + 1L);
    }

    public UnsignedLong incOrWrap() {
        if (this.equals(MAX_VALUE)) {
            return MIN_VALUE;
        }
        return this.inc();
    }

    public UnsignedLong incOrWrapTo(UnsignedLong unsignedLong) {
        if (this.equals(MAX_VALUE)) {
            return unsignedLong;
        }
        return this.inc();
    }

    @Override
    public int intValue() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return (int)(this.value & Integer.MAX_VALUE) | Integer.MIN_VALUE;
        }
        return (int)this.value;
    }

    @Override
    public boolean isBitSet(int n2) {
        if (n2 < 0 || n2 > 63) {
            return false;
        }
        return (this.value >> n2 & 1L) >= 1L;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public UnsignedLong subtract(long l2) {
        if (this.getValue() >= 0L && this.getValue() > l2) {
            return UnsignedLong.valueOf(this.getValue() - l2);
        }
        BigInteger bigInteger = this.bigIntegerValue();
        bigInteger = bigInteger.subtract(BigInteger.valueOf(l2));
        return new UnsignedLong(bigInteger);
    }

    public UnsignedLong subtract(UnsignedLong unsignedLong) {
        if (this.getValue() < 0L || unsignedLong.getValue() < 0L) {
            return new UnsignedLong(this.bigIntegerValue().subtract(unsignedLong.bigIntegerValue()));
        }
        return UnsignedLong.valueOf(this.getValue() - unsignedLong.getValue());
    }

    public long toLongBits() {
        return this.value;
    }

    public String toString() {
        if ((this.value & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return this.bigIntegerValue().toString();
        }
        return Long.toString(this.value);
    }

    private long getValue() {
        return this.value;
    }

    static {
        ZERO = MIN_VALUE = new UnsignedLong(BI_MIN_VALUE);
        ONE = new UnsignedLong(1);
        EMPTY_ARRAY = new UnsignedLong[0];
        UnsignedLong.CACHE[0] = ZERO;
        UnsignedLong.CACHE[1] = ONE;
        for (int i2 = 2; i2 < CACHE.length; ++i2) {
            UnsignedLong.CACHE[i2] = new UnsignedLong(i2);
        }
    }
}

