/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Objects;

public class DataValue
implements Cloneable {
    @Deprecated
    public static final NodeId ID = Identifiers.DataValue;
    public static final DataValue[] EMPTY_ARRAY = new DataValue[0];
    Variant iu;
    StatusCode statusCode;
    DateTime qR;
    UnsignedShort qX;
    DateTime qW;
    UnsignedShort rL;

    public DataValue() {
        this(StatusCode.GOOD);
    }

    public DataValue(StatusCode statusCode) {
        this(Variant.NULL, statusCode);
    }

    public DataValue(Variant variant) {
        this(variant, StatusCode.GOOD);
    }

    public DataValue(Variant variant, StatusCode statusCode) {
        this(variant, statusCode, null, null, null, null);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, DateTime dateTime2) {
        this(variant, statusCode, dateTime, null, dateTime2, null);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort, DateTime dateTime2, UnsignedShort unsignedShort2) {
        this.statusCode = statusCode == null ? StatusCode.GOOD : statusCode;
        this.qR = dateTime;
        this.qW = dateTime2;
        this.qX = unsignedShort == null ? UnsignedShort.ZERO : unsignedShort;
        this.rL = unsignedShort2 == null ? UnsignedShort.ZERO : unsignedShort2;
        this.setValue(variant);
    }

    public DataValue clone() {
        try {
            DataValue dataValue = (DataValue)super.clone();
            dataValue.iu = dataValue.iu == null ? null : new Variant(StructureUtils.clone(dataValue.iu.getValue()));
            return dataValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not call super.clone on DataValue even when it implements Cloneable");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataValue)) {
            return false;
        }
        DataValue dataValue = (DataValue)object;
        return Objects.equals(dataValue.iu, this.iu) && Objects.equals(dataValue.statusCode, this.statusCode) && Objects.equals(dataValue.qR, this.qR) && Objects.equals(dataValue.qW, this.qW) && Objects.equals(dataValue.qX, this.qX) && Objects.equals(dataValue.rL, this.rL);
    }

    public UnsignedShort getServerPicoseconds() {
        return this.rL;
    }

    public DateTime getServerTimestamp() {
        return this.qW;
    }

    public UnsignedShort getSourcePicoseconds() {
        return this.qX;
    }

    public DateTime getSourceTimestamp() {
        return this.qR;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Variant getValue() {
        return this.iu;
    }

    public int hashCode() {
        return Objects.hash(this.iu, this.statusCode, this.qR, this.qX, this.qW, this.rL);
    }

    public boolean isNull() {
        return this.iu.getValue() == null;
    }

    public void setServerPicoseconds(UnsignedShort unsignedShort) {
        this.rL = unsignedShort;
    }

    public void setServerTimestamp(DateTime dateTime) {
        this.qW = dateTime;
    }

    public void setSourcePicoseconds(UnsignedShort unsignedShort) {
        this.qX = unsignedShort;
    }

    public void setSourceTimestamp(DateTime dateTime) {
        this.qR = dateTime;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode == null ? StatusCode.GOOD : statusCode;
    }

    public void setStatusCode(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            this.setStatusCode(StatusCode.GOOD);
        } else {
            this.setStatusCode(StatusCode.valueOf(unsignedInteger));
        }
    }

    public void setValue(Variant variant) {
        this.iu = variant == null ? Variant.NULL : variant;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataValue(");
        stringBuilder.append("value=" + this.iu);
        stringBuilder.append(", statusCode=" + this.statusCode);
        stringBuilder.append(", sourceTimestamp=" + this.qR);
        stringBuilder.append(", sourcePicoseconds=" + this.qX);
        stringBuilder.append(", serverTimestamp=" + this.qW);
        stringBuilder.append(", serverPicoseconds=" + this.rL);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

