/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;

public final class ByteString
implements BitField,
Comparable<ByteString> {
    public static final ByteString EMPTY = new ByteString(new byte[0], false);
    public static final ByteString[] EMPTY_ARRAY = new ByteString[0];
    private final byte[] value;

    public static byte[] asByteArray(ByteString byteString) {
        return byteString == null ? null : byteString.getValue();
    }

    public static ByteString from(ByteArrayOutputStream byteArrayOutputStream) {
        if (byteArrayOutputStream == null) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length == 0) {
            return EMPTY;
        }
        return new ByteString(byArray, false);
    }

    public static ByteString fromBitSet(BitSet bitSet) {
        if (bitSet == null) {
            return null;
        }
        byte[] byArray = new byte[(bitSet.length() + 7) / 8];
        for (int i2 = 0; i2 < bitSet.length(); ++i2) {
            if (!bitSet.get(i2)) continue;
            int n2 = i2 / 8;
            byArray[n2] = (byte)(byArray[n2] | 1 << i2 % 8);
        }
        return ByteString.valueOf(byArray);
    }

    public static ByteString fromBitSet(BitSet bitSet, int n2) {
        ByteString byteString = ByteString.fromBitSet(bitSet);
        if (byteString.getLength() < n2) {
            return byteString.append(new byte[n2 - byteString.getLength()]);
        }
        return byteString;
    }

    public static ByteString fromHex(String string) {
        return ByteString.valueOf(CryptoUtil.hexToBytes(string));
    }

    public static ByteString fromLong(long l2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteArrayOutputStream);
        try {
            binaryEncoder.putInt64((String)null, l2);
        }
        catch (EncodingException encodingException) {
            throw new IllegalStateException("Encoding of Int64 failed, should not happen", encodingException);
        }
        return ByteString.from(byteArrayOutputStream);
    }

    public static ByteString fromUUID(UUID uUID) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteArrayOutputStream);
        try {
            binaryEncoder.putGuid(null, uUID);
        }
        catch (EncodingException encodingException) {
            throw new IllegalStateException("Encoding of UUID failed, should not happen", encodingException);
        }
        return ByteString.from(byteArrayOutputStream);
    }

    public static ByteString valueOf(byte ... byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY;
        }
        return new ByteString(byArray, true);
    }

    static boolean a(byte by, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("internal failure in resolving set bits, position out of range 0-7, was: " + n2);
        }
        return (by & 1 << n2) != 0;
    }

    private ByteString(byte[] byArray, boolean bl) {
        this.value = bl ? Arrays.copyOf(byArray, byArray.length) : byArray;
    }

    public ByteString append(byte[] byArray) {
        if (byArray == null) {
            return this;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.value, 0, this.value.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return ByteString.from(byteArrayOutputStream);
    }

    public ByteString append(ByteString byteString) {
        if (byteString == null) {
            return this;
        }
        return this.append(byteString.value);
    }

    @Override
    public int compareTo(ByteString byteString) {
        if (this.equals(byteString)) {
            return 0;
        }
        return this.toString().compareTo(byteString.toString());
    }

    public void copyTo(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(this.value, 0, this.value.length);
    }

    public void copyTo(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3) {
        byteArrayOutputStream.write(this.value, n2, n3);
    }

    public void copyTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.value, 0, this.value.length);
    }

    public void copyTo(OutputStream outputStream, int n2, int n3) throws IOException {
        outputStream.write(this.value, n2, n3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        return Arrays.equals(this.value, byteString.value);
    }

    public int getLength() {
        return this.value.length;
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.value);
        return n3;
    }

    @Override
    public boolean isBitSet(int n2) {
        int n3 = n2 / 8;
        int n4 = n2 % 8;
        if (n3 >= this.value.length) {
            return false;
        }
        return ByteString.a(this.value[n3], n4);
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.getLength() * 8);
        for (int i2 = 0; i2 < this.getLength() * 8; ++i2) {
            if (!this.isBitSet(i2)) continue;
            bitSet.set(i2);
        }
        return bitSet;
    }

    public String toHex() {
        return CryptoUtil.toHex(this.value, 0, false);
    }

    public String toString() {
        return CryptoUtil.toHex(this.value, 0);
    }
}

