/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.GetEndpointsRequest;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointDiscoveryService {
    private static Logger logger = LoggerFactory.getLogger(EndpointDiscoveryService.class);
    EndpointBindingCollection endpointBindings;

    public EndpointDiscoveryService(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
    }

    public EndpointBindingCollection getEndpointCollection() {
        return this.endpointBindings;
    }

    public void onGetEndpoints(EndpointServiceRequest<GetEndpointsRequest, GetEndpointsResponse> endpointServiceRequest) throws ServiceFaultException {
        EndpointDescription[] endpointDescriptionArray;
        SocketAddress socketAddress = endpointServiceRequest.getChannel().getConnection().getLocalAddress();
        logger.debug("onGetEndpoints: requestAddress={}", (Object)socketAddress);
        logger.trace("onGetEndpoints: Request={}", (Object)endpointServiceRequest.getRequest());
        GetEndpointsResponse getEndpointsResponse = new GetEndpointsResponse();
        String string = this.A(endpointServiceRequest.getRequest().getEndpointUrl());
        String string2 = this.y(string);
        String string3 = this.z(string);
        Object[] objectArray = endpointServiceRequest.getRequest().getProfileUris();
        logger.debug("onGetEndpoints: requestUrl={}", (Object)string);
        logger.debug("onGetEndpoints: host={}", (Object)string2);
        logger.debug("onGetEndpoints: serverName={}", (Object)string3);
        logger.debug("onGetEndpoints: profileUris={}", (Object)Arrays.toString(objectArray));
        List<Object> list = objectArray == null ? new ArrayList(0) : Arrays.asList(objectArray);
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>();
        List<Server> list2 = this.endpointBindings.getServiceServers();
        for (Server server : list2) {
            for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions(socketAddress)) {
                logger.debug("ed.TransportProfileUri={}", (Object)endpointDescription.getTransportProfileUri());
                if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri())) continue;
                logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                String string4 = this.y(endpointDescription.getEndpointUrl());
                String string5 = this.z(endpointDescription.getEndpointUrl());
                if (!string.isEmpty() && (!string4.equals(string2) || !string3.isEmpty() && !string5.equals(string3))) continue;
                arrayList.add(endpointDescription);
            }
        }
        if (arrayList.isEmpty()) {
            logger.debug("onGetEndpoints: no matching endpoints for requested hostname, checking all with the same serverName");
            for (Server server : list2) {
                for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions()) {
                    if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri()) || !string3.isEmpty() && !string3.equals(this.z(endpointDescription.getEndpointUrl()))) continue;
                    logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                    arrayList.add(endpointDescription);
                }
            }
        }
        if (arrayList.isEmpty()) {
            logger.debug("onGetEndpoints: no matching endpoints ignoring host, adding all");
            for (Server server : list2) {
                for (EndpointDescription endpointDescription : endpointDescriptionArray = server.getEndpointDescriptions()) {
                    if (!list.isEmpty() && !list.contains(endpointDescription.getTransportProfileUri())) continue;
                    logger.debug("ed.EndpointUrl={}", (Object)endpointDescription.getEndpointUrl());
                    arrayList.add(endpointDescription);
                }
            }
        }
        logger.trace("onGetEndpoints: list={}", (Object)arrayList);
        getEndpointsResponse.setEndpoints(arrayList.toArray(new EndpointDescription[0]));
        ResponseHeader responseHeader = new ResponseHeader(DateTime.currentTime(), endpointServiceRequest.getRequest().getRequestHeader().getRequestHandle(), null, null, null, null);
        getEndpointsResponse.setResponseHeader(responseHeader);
        endpointServiceRequest.sendResponse(getEndpointsResponse, null);
    }

    public void setEndpointBindingCollection(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
    }

    private String y(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf("://") + 3;
        if (n2 < 3) {
            return "";
        }
        int n3 = string.indexOf(":", n2);
        if (n3 < n2) {
            n3 = string.indexOf("/", n2);
        }
        String string2 = n3 > n2 ? string.substring(n2, n3) : string.substring(n2);
        return string2.toLowerCase(Locale.ROOT);
    }

    private String z(String string) {
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf("://") + 3;
        if ((n2 = string.indexOf("/", n2) + 1) < 1) {
            return "";
        }
        return string.substring(n2);
    }

    private String A(String string) {
        if (string == null) {
            return "";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

