/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    ApplicationDescription K = new ApplicationDescription();
    List<KeyPair> rp = new CopyOnWriteArrayList<KeyPair>();
    List<SignedSoftwareCertificate> rq = new CopyOnWriteArrayList<SignedSoftwareCertificate>();
    List<Locale> lW = new CopyOnWriteArrayList<Locale>();
    HttpsSettings gb = new HttpsSettings();
    OpcTcpSettings rr = new OpcTcpSettings();
    private EncoderContext kg = new EncoderContext(new NamespaceTable(), new ServerTable());

    public Application() {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.K.setApplicationUri("urn:" + string + ":" + UUID.randomUUID());
        this.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        this.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
    }

    public void addApplicationInstanceCertificate(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.rp.add(keyPair);
    }

    public void addLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.lW.add(locale);
    }

    public void addSoftwareCertificate(SignedSoftwareCertificate signedSoftwareCertificate) {
        if (signedSoftwareCertificate == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.rq.add(signedSoftwareCertificate);
    }

    public ApplicationDescription getApplicationDescription() {
        return this.K;
    }

    public KeyPair getApplicationInstanceCertificate() {
        int n2 = this.rp.size() - 1;
        if (n2 < 0) {
            return null;
        }
        return this.rp.get(n2);
    }

    public KeyPair getApplicationInstanceCertificate(byte[] byArray) {
        logger.debug("getApplicationInstanceCertificate: expected={}", (Object)CryptoUtil.toHex(byArray));
        if (byArray != null) {
            int n2 = 0;
            for (KeyPair keyPair : this.rp) {
                byte[] byArray2 = keyPair.getCertificate().getEncodedThumbprint();
                logger.debug("getApplicationInstanceCertificate: cert[{}]={}", (Object)n2++, (Object)CryptoUtil.toHex(byArray2));
                if (!Arrays.equals(byArray2, byArray)) continue;
                return keyPair;
            }
        }
        return null;
    }

    public KeyPair[] getApplicationInstanceCertificates() {
        return this.rp.toArray(new KeyPair[this.rp.size()]);
    }

    public String getApplicationUri() {
        return this.K.getApplicationUri();
    }

    public EncoderContext getEncoderContext() {
        return this.kg;
    }

    public HttpsSettings getHttpsSettings() {
        return this.gb;
    }

    public String[] getLocaleIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.lW.size());
        for (Locale locale : this.lW) {
            arrayList.add(LocalizedText.toLocaleId(locale));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Locale[] getLocales() {
        return this.lW.toArray(new Locale[0]);
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.rr;
    }

    public String getProductUri() {
        return this.K.getProductUri();
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        return this.rq.toArray(new SignedSoftwareCertificate[this.rq.size()]);
    }

    public void removeApplicationInstanceCertificate(KeyPair keyPair) {
        this.rp.remove(keyPair);
    }

    public void removeApplicationInstanceCertificates() {
        this.rp.clear();
    }

    public void removeLocale(Locale locale) {
        this.lW.remove(locale);
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.K.setApplicationName(localizedText);
    }

    public void setApplicationUri(String string) {
        this.K.setApplicationUri(string);
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.gb = httpsSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.rr = opcTcpSettings;
    }

    public void setProductUri(String string) {
        this.K.setProductUri(string);
    }
}

