/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaServerReference.class);
    private UaNode rj;
    private final NodeId eb;
    private Boolean rk = null;
    private UaNode rg = null;
    private UaNode rh = null;

    public static UaServerReference getReferenceInstance(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(nodeId, uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(nodeId, uaNode, uaNode2);
    }

    public static UaServerReference getReferenceInstance(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(uaReferenceType.getNodeId(), uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(uaReferenceType, uaNode, uaNode2);
    }

    private static UaServerReference a(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        if (UaServerReference.b(nodeId, uaNode, uaNode2)) {
            return null;
        }
        UaReference[] uaReferenceArray = uaNode.getReferences(nodeId, false);
        if (uaReferenceArray != null) {
            for (UaReference uaReference : uaReferenceArray) {
                if (!uaReference.getTargetId().equals(uaNode2.getNodeId())) continue;
                return (UaServerReference)uaReference;
            }
        }
        return null;
    }

    private static boolean b(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (Identifiers.HasProperty.equals(nodeId)) {
            return false;
        }
        if (!(uaNode instanceof ServerNode) || !(uaNode2 instanceof ServerNode)) {
            return false;
        }
        UaServerReference uaServerReference = new UaServerReference(nodeId, uaNode, uaNode2);
        ServerNode serverNode = (ServerNode)uaNode;
        return serverNode.re && !serverNode.getReferenceList().contains(uaServerReference);
    }

    public UaServerReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        this.eb = nodeId;
        this.o(uaNode2);
        this.n(uaNode);
    }

    public UaServerReference(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        this(uaReferenceType.getNodeId(), uaNode, uaNode2);
        this.rj = uaReferenceType;
    }

    @Override
    public int compareTo(UaReference uaReference) {
        if (!(uaReference instanceof UaServerReference)) {
            return super.compareTo(uaReference);
        }
        int n2 = this.getSourceNode().getNodeId().compareTo(uaReference.getSourceNode().getNodeId());
        if (n2 == 0) {
            n2 = this.getTargetNode().getNodeId().compareTo(uaReference.getTargetNode().getNodeId());
        }
        if (n2 == 0) {
            n2 = this.getReferenceTypeId().compareTo(uaReference.getReferenceTypeId());
        }
        return n2;
    }

    @Override
    public void delete() {
        this.rg.deleteReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaServerReference uaServerReference = (UaServerReference)object;
        if (this.rh == null ? uaServerReference.rh != null : this.rh != uaServerReference.rh) {
            return false;
        }
        if (this.rg == null ? uaServerReference.rg != null : this.rg != uaServerReference.rg) {
            return false;
        }
        return !(this.eb == null ? uaServerReference.eb != null : !this.eb.equals(uaServerReference.eb));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.rg.getNodeId().equals(nodeId);
        if (bl && !this.rh.getNodeId().equals(nodeId)) {
            throw new IllegalArgumentException("getIsInverse: node is neither targetNode nor sourceNode");
        }
        return bl;
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.rg.getNodeId().equals(uaNode.getNodeId());
        if (bl && !this.rh.getNodeId().equals(uaNode.getNodeId())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "getIsInverse: node (%s) is neither targetNode (%s) nor sourceNode (%s); referenceType=%s", uaNode.getNodeId(), this.getTargetId(), this.getSourceId(), this.getReferenceType().getBrowseName()));
        }
        return bl;
    }

    @Override
    public UaReferenceType getReferenceType() {
        if (this.rj == null) {
            try {
                ServerNode serverNode = null;
                if (this.rg instanceof ServerNode) {
                    serverNode = (ServerNode)this.rg;
                } else if (this.rh instanceof ServerNode) {
                    serverNode = (ServerNode)this.rh;
                }
                if (serverNode != null) {
                    this.rj = serverNode.getNodeManager().getNode(this.eb);
                }
            }
            catch (StatusException statusException) {
                logger.debug("ReferenceType " + this.eb + " could not be found");
                return null;
            }
        }
        if (this.rj instanceof UaReferenceType) {
            return (UaReferenceType)this.rj;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.eb;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return new ExpandedNodeId(this.rg.getNodeId());
    }

    @Override
    public UaNode getSourceNode() {
        return this.rg;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return new ExpandedNodeId(this.rh.getNodeId());
    }

    @Override
    public UaNode getTargetNode() {
        return this.rh;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.eb == null ? 0 : this.eb.hashCode());
        n3 = 31 * n3 + (this.rh == null ? 0 : this.rh.getNodeId().hashCode());
        n3 = 31 * n3 + (this.rg == null ? 0 : this.rg.getNodeId().hashCode());
        return n3;
    }

    public boolean isSymmetric() {
        this.cnC();
        return this.rk != null && this.rk != false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.getReferenceType();
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        }
        if (!(this.rg instanceof UaExternalNode)) {
            stringBuilder.append(" SourceNode=");
            stringBuilder.append(this.rg.getBrowseName());
        }
        if (!(this.rh instanceof UaExternalNode)) {
            stringBuilder.append(" TargetNode=");
            stringBuilder.append(this.rh.getBrowseName());
        }
        return super.toString() + stringBuilder.toString();
    }

    private void cnC() {
        UaReferenceType uaReferenceType;
        if (this.rk == null && (uaReferenceType = this.getReferenceType()) != null) {
            this.rk = uaReferenceType.getSymmetric() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    private void n(UaNode uaNode) {
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        this.rg = uaNode;
    }

    private void o(UaNode uaNode) {
        if (uaNode == null) {
            throw new NullPointerException("targetNode");
        }
        this.rh = uaNode;
    }
}

