/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.AbstractUaNodeFactory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.CacheProperty;
import com.prosysopc.ua.server.nodes.CacheVariable;
import com.prosysopc.ua.server.nodes.UaDataTypeNode;
import com.prosysopc.ua.server.nodes.UaMethodNode;
import com.prosysopc.ua.server.nodes.UaObjectNode;
import com.prosysopc.ua.server.nodes.UaObjectTypeNode;
import com.prosysopc.ua.server.nodes.UaReferenceTypeNode;
import com.prosysopc.ua.server.nodes.UaVariableTypeNode;
import com.prosysopc.ua.server.nodes.UaViewNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.NodeClass;

public class UaServerNodeFactory
extends AbstractUaNodeFactory {
    private final NodeManagerUaNode nodeManager;

    public UaServerNodeFactory(NodeManagerUaNode nodeManagerUaNode) {
        super(nodeManagerUaNode.getNodeManagerTable());
        this.nodeManager = nodeManagerUaNode;
        try {
            this.registerNodeClass(NodeClass.Object, parameters -> new UaObjectNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.Variable, parameters -> new CacheVariable((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.Method, parameters -> new UaMethodNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.ObjectType, parameters -> new UaObjectTypeNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.VariableType, parameters -> new UaVariableTypeNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.ReferenceType, parameters -> new UaReferenceTypeNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.DataType, parameters -> new UaDataTypeNode((UaNode.Parameters)parameters));
            this.registerNodeClass(NodeClass.View, parameters -> new UaViewNode((UaNode.Parameters)parameters));
            this.registerTypeDefinition(UaIds.PropertyType, parameters -> new CacheProperty((UaNode.Parameters)parameters));
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            throw new RuntimeException("Error creating default server node factory", uaNodeFactoryException);
        }
    }

    @Override
    protected NamespaceTable getNamespaceTable() {
        return this.nodeManager.getNamespaceTable();
    }

    @Override
    protected RegisteredClasses getRegisteredClasses() {
        return this.nodeManager.getServer().getRegisteredClasses();
    }

    @Override
    protected UaType getType(UaNodeId uaNodeId) throws Exception {
        return this.nodeManager.getNodeManagerTable().getType(NodeId.from(uaNodeId, this.getNamespaceTable()));
    }
}

