/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.encoding.DecodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UaMethodNode
extends BaseNode
implements UaMethod {
    protected static final QualifiedName INPUT_ARGUMENTS = new QualifiedName("InputArguments");
    protected static final QualifiedName OUTPUT_ARGUMENTS = new QualifiedName("OutputArguments");
    Boolean hj = true;
    Boolean hk = true;

    public UaMethodNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public UaMethodNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected UaMethodNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new MethodAttributes());
    }

    @Override
    public Boolean getExecutable() {
        return this.hj;
    }

    @Override
    public Argument[] getInputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(INPUT_ARGUMENTS));
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Method;
    }

    @Override
    public Argument[] getOutputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(OUTPUT_ARGUMENTS));
    }

    @Override
    public Boolean getUserExecutable() {
        return this.hk;
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        GenericAttributes genericAttributes;
        if (nodeAttributes instanceof MethodAttributes) {
            this.setExecutable(((MethodAttributes)nodeAttributes).getExecutable());
        } else if (nodeAttributes instanceof GenericAttributes && (genericAttributes = (GenericAttributes)nodeAttributes).getAttributeValues() != null) {
            for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                if (!Attributes.Executable.equals(genericAttributeValue.getAttributeId())) continue;
                this.setExecutable((Boolean)genericAttributeValue.getValue());
            }
        }
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setExecutable(Boolean bl) {
        this.hj = bl;
    }

    @Override
    public void setUserExecutable(Boolean bl) {
        this.hk = bl;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private Argument[] a(UaProperty uaProperty) throws MethodArgumentException {
        ExtensionObject[] extensionObjectArray;
        if (uaProperty == null || uaProperty.getValue().isNull()) {
            return new Argument[0];
        }
        Object object = uaProperty.getValue().getValue().getValue();
        if (object instanceof Argument[]) {
            return (Argument[])object;
        }
        try {
            extensionObjectArray = (ExtensionObject[])object;
        }
        catch (ClassCastException classCastException) {
            throw new MethodArgumentException("Property does not contain argument values.");
        }
        int n2 = extensionObjectArray == null ? 0 : extensionObjectArray.length;
        Argument[] argumentArray = new Argument[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                argumentArray[i2] = (Argument)extensionObjectArray[i2].decode(this.nodeManager.getNodeManagerTable().getEncoderContext());
                continue;
            }
            catch (DecodingException decodingException) {
                throw new MethodArgumentException("Cannot decode argument value #" + i2);
            }
        }
        return argumentArray;
    }

    protected NodeAttributes getAttributes(MethodAttributes methodAttributes) {
        super.getAttributes(methodAttributes);
        methodAttributes.setExecutable(this.getExecutable());
        methodAttributes.setUserExecutable(this.getUserExecutable());
        return methodAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.Executable, this.getExecutable());
        map.put(Attributes.UserExecutable, this.getUserExecutable());
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Executable);
        list.add(Attributes.UserExecutable);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Executable)) {
            dataValue.setValue(new Variant(this.hj));
        } else if (unsignedInteger.equals(Attributes.UserExecutable)) {
            dataValue.setValue(new Variant(this.hk));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.Executable)) {
            this.hj = (Boolean)object;
        } else if (unsignedInteger.equals(Attributes.UserExecutable)) {
            this.hk = (Boolean)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

